package ru.yandex.autotests.direct.api.bidmodifiers.add.smarttv;

import com.google.common.primitives.Shorts;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.HierarchicalMultipliersType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.HierarchicalMultipliersRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SmartTvAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasProperty;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@Description("Позитивные сценарии добавления смарт-тв корректировок")
public class AddBidModifiersSmartTvTest {
    private static final String LOGIN = BidModifiersLogins.SINGLE_CLIENT_ADD;
    private static final String DESKTOP_ID_PREFIX = "19";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static Long campaignId;
    private Long adGroupId;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
    }

    @Before
    public void before() {
        adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(campaignId);
    }

    @Test
    public void addMaximumAdjustmentAndCheckValueInDatabase() {
        HierarchicalMultipliersRecord dbRecord =
                createSmartTvAdjustmentAndGetDbRecord(SmartTvAdjustmentMap.SMARTTV_ADJUSTMENT_ABSOLUTE_MIN);

        assertThat("Запись в БД создана с правильным коэффициентом",
                dbRecord.getMultiplierPct(), equalTo(Shorts.checkedCast(SmartTvAdjustmentMap.SMARTTV_ADJUSTMENT_ABSOLUTE_MIN)));
    }

    @Test
    public void addAdjustmentAndCheckTypeInDatabase() {
        HierarchicalMultipliersRecord dbRecord =
                createSmartTvAdjustmentAndGetDbRecord(BidModifierAddMap.DEFAULT_BID_MODIFIER);
        assertThat("Запись в БД создана правильно",
                dbRecord,
                allOf(
                        hasProperty("cid", equalTo(campaignId)),
                        hasProperty("pid", equalTo(adGroupId)),
                        hasProperty("type", equalTo(HierarchicalMultipliersType.smarttv_multiplier)),
                        hasProperty("multiplierPct",
                                equalTo(Shorts.checkedCast(BidModifierAddMap.DEFAULT_BID_MODIFIER))),
                        hasProperty("isEnabled", equalTo(1))
                )
        );
    }
    @Test
    public void addMinimalAdjustmentAndCheckValueInDatabase() {
        HierarchicalMultipliersRecord dbRecord =
                createSmartTvAdjustmentAndGetDbRecord(SmartTvAdjustmentMap.SMARTTV_ADJUSTMENT_ABSOLUTE_MIN);

        assertThat("Запись в БД создана с правильным коэффициентом",
                dbRecord.getMultiplierPct(),
                equalTo(Shorts.checkedCast(SmartTvAdjustmentMap.SMARTTV_ADJUSTMENT_ABSOLUTE_MIN)));
    }

    private HierarchicalMultipliersRecord createSmartTvAdjustmentAndGetDbRecord(int bidModifierMultiplierPct) {
        api.userSteps.bidModifiersSteps().shouldGetResultOnAdd(
                new AddRequestMap().withBidModifiers(
                        new BidModifierAddMap()
                                .withAdGroupId(adGroupId)
                                .withSmartTvAdjustment(
                                        new SmartTvAdjustmentMap().withBidModifier(bidModifierMultiplierPct))
                ),
                MultiIdsExpectedResult.success()
        );
        return api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN)
                .multipliersSteps().getHierarchicalMultipliersByPid(adGroupId)
                .get(0);
    }

}
