package ru.yandex.autotests.direct.api.bidmodifiers.add.video;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.VideoAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by liosha on 16.01.2018.
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@Description("Негативные сценарии добавления видео корректировок ставок")
public class AddBidModifiersVideoNegativeTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_ADD;

    private static Long campaignArchived;
    private static Long groupId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    @Step("Подготовим данные для теста")
    public void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignArchived = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignArchived);
        api.userSteps.campaignSteps().campaignsSuspend(campaignArchived);
        api.userSteps.campaignSteps().campaignsArchive(campaignArchived);
    }

    @Test
    @Description("Попробуем добавить корректировку ставки в архивную кампанию")
    public void archivedCampaignTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withVideoAdjustment(new VideoAdjustmentMap().defaultVideoAdjustment())
                        .withCampaignId(campaignArchived)),
                MultiIdsExpectedResult.errors(new Notification(8300, Api5ErrorDetails.UNABLE_UPDATE_ARCHIVED_CAMPAGN)));
    }

    @Test
    @Description("Попробуем добавить корректировку ставки на группу в архивную кампанию")
    public void archivedCampaignAdGroupTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withVideoAdjustment(new VideoAdjustmentMap().defaultVideoAdjustment())
                        .withAdGroupId(groupId)),
                MultiIdsExpectedResult.errors(new Notification(8300, Api5ErrorDetails.UNABLE_UPDATE_ARCHIVED_CAMPAGN)));
    }
}
