package ru.yandex.autotests.direct.api.bidmodifiers.add.video;

import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.VideoAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.List;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.startsWith;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by liosha on 16.01.2018.
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@Description("Позитивные сценарии добавления видео корректировок ставок")
public class AddBidModifiersVideoTest {
    private static LogSteps log = LogSteps.getLogger(AddBidModifiersVideoTest.class);
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_ADD;

    private static Long campaignID;
    private static Long groupID;

    private final String ID_PREFIX = "14";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignStepsV5().addDefaultTextCampaign(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
    }

    @Test
    public void bidModifierToGroupTest() {
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withVideoAdjustment(new VideoAdjustmentMap()
                        .defaultVideoAdjustment())
                .withAdGroupId(groupID));

        assertThat("добавлена видео корректировка ставок", bmIds, hasSize(1));
    }

    @Test
    public void bidModifierToCampaignTest() {
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withVideoAdjustment(new VideoAdjustmentMap()
                        .defaultVideoAdjustment())
                .withCampaignId(campaignID));

        assertThat("добавлена видео корректировка ставок", bmIds, hasSize(1));
    }

    @Test
    @Description("Идентификатор видео корректировки ставки должен начинаться с префикса - " + ID_PREFIX)
    public void complexIdentificatorVideoTest() {
        Long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withVideoAdjustment(new VideoAdjustmentMap()
                        .withBidModifier(112))
                .withAdGroupId(groupID));
        assumeThat("добавлена видео корректировка ставки", bmIds, hasSize(1));

        assertThat("идентификатор видео корректировки ставки начинается с корректного префикса",
                String.valueOf(bmIds.get(0)), startsWith(ID_PREFIX));
    }
}
