package ru.yandex.autotests.direct.api.bidmodifiers.delete;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;

/**
 * Created by chicos on 31.07.15
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Description("Удаление максимального числа корректировок ставок в одном запросе")
public class DeleteBidModifiersMaxIdsTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_DELETE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @Description("Удаление максимального количества " + IdsCriteriaMap.IDS_MAX_LENGTH + " корректировок ставок за один запрос")
    public void deleteMaxBidModifierIdsTest() {
        Long[] fakeIds = new Long[IdsCriteriaMap.BID_MODIFIERS_IDS_MAX_LENGTH];
        for (int i = 0; i < fakeIds.length; i++) {
            fakeIds[i] = Long.parseLong(RandomStringUtils.randomNumeric(9));
        }

        ExpectedResult[] expectedResults = new ExpectedResult[IdsCriteriaMap.BID_MODIFIERS_IDS_MAX_LENGTH];
        Arrays.fill(expectedResults, ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.BID_MODIFIER_NOT_FOUND)));

        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(fakeIds)),
                expectedResults);
    }
}
