package ru.yandex.autotests.direct.api.bidmodifiers.delete;

import java.util.List;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import com.yandex.direct.api.v5.general.AgeRangeEnum;
import com.yandex.direct.api.v5.general.GenderEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DemographicsAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.emptyIterable;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 31.07.15
 */
@Aqua.Test
@Features(BidModifiersFeatures.DELETE)
@Tag(TagDictionary.TRUNK)
@Description("Проверка позитивных сценариев удаления корректировок ставок")
public class DeleteBidModifiersPositiveMultipleTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String CLIENT = BidModifiersLogins.SINGLE_CLIENT_DELETE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long textCampaignId;
    private static Long cpmCampaignId;

    private long textGroupId;
    private Long cpmAdGroupId;

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        cpmCampaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        textGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(textCampaignId);
        cpmAdGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(cpmCampaignId);
    }

    @Test
    @Description("Удаление корректировок ставок разных типов в одном запросе для CPM кампании")
    public void deleteBidModifiersDifferentTypeInCpmCampaignTest() {
        log.info("Подготовим корректировки ставок разных типов");
        Long mobileBidModifier = api.userSteps.bidModifiersSteps().addBidModifierMobileToGroup(cpmAdGroupId);
        Long desktopBidModifier = api.userSteps.bidModifiersSteps().addBidModifierDesktopToGroup(cpmAdGroupId);

        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(mobileBidModifier, desktopBidModifier)),
                ExpectedResult.success(),
                ExpectedResult.success()
        );
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps()
                .bidModifiersGetById(mobileBidModifier, desktopBidModifier);
        assertThat("корректировки ставок удалены", bms, emptyIterable());
    }

    @Test
    @Description("Удаление корректировок ставок разных типов в одном запросе")
    public void deleteBidModifiersDifferentTypeTest() {
        log.info("Подготовим корректировки ставок разных типов");
        Integer conditionId = api.userSteps.retargetingSteps().addRandomRetargetingCondition(CLIENT);
        Long bmID1 = api.userSteps.bidModifiersSteps().addBidModifierRetargetingToGroup(conditionId.longValue(),
                textGroupId);
        Long bmID2 = api.userSteps.bidModifiersSteps().addBidModifierMobileToGroup(textGroupId);
        Long bmID3 = api.userSteps.bidModifiersSteps().addBidModifierDemographicsToGroup(textGroupId);
        Long bmID4 = api.userSteps.bidModifiersSteps().addBidModifierVideoToGroup(textGroupId);

        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(bmID1, bmID2, bmID3, bmID4)),
                ExpectedResult.success(),
                ExpectedResult.success(),
                ExpectedResult.success(),
                ExpectedResult.success()
        );
        List<BidModifierGetItem> bms =
                api.userSteps.bidModifiersSteps().bidModifiersGetById(bmID1, bmID2, bmID3, bmID4);
        assertThat("корректировки ставок удалены", bms, emptyIterable());
    }

    @Test
    @Description("Удаление нескольких корректировок ставок одного типа")
    public void deleteBidModifiersSameTypeTest() {
        log.info("Подготовим демографические корректировки ставок");
        List<Long> bmIDs = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withDemographicsAdjustment(new DemographicsAdjustmentMap()
                                .withGender(GenderEnum.GENDER_FEMALE)
                                .withAge(AgeRangeEnum.AGE_18_24)
                                .withDefaultBidModifier(),
                        new DemographicsAdjustmentMap()
                                .withGender(GenderEnum.GENDER_MALE)
                                .withAge(AgeRangeEnum.AGE_25_34)
                                .withDefaultBidModifier())
                .withAdGroupId(textGroupId));
        assumeThat("созданы корректировки ставок", bmIDs, hasSize(2));

        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(bmIDs.get(0), bmIDs.get(1))),
                ExpectedResult.success(),
                ExpectedResult.success()
        );

        List<BidModifierGetItem> bms =
                api.userSteps.bidModifiersSteps().bidModifiersGetById(bmIDs.get(0), bmIDs.get(1));
        assertThat("корректировки ставок удалены", bms, emptyIterable());
    }

    @Test
    @Description("Удаление корректировок ставок на камапанию разных типов в одном запросе")
    public void deleteBidModifiersDifferentTypeCampaignTest() {
        log.info("Подготовим корректировки ставок разных типов");
        Integer conditionId = api.userSteps.retargetingSteps().addRandomRetargetingCondition(CLIENT);
        Long bmID1 = api.userSteps.bidModifiersSteps()
                .addBidModifierRetargetingToCampaign(conditionId.longValue(), textCampaignId
                        .intValue());
        Long bmID2 = api.userSteps.bidModifiersSteps().addBidModifierMobileToCampaign(textCampaignId);
        Long bmID3 = api.userSteps.bidModifiersSteps().addBidModifierDemographicsToCampaign(textCampaignId.intValue());
        Long bmID4 = api.userSteps.bidModifiersSteps().addBidModifierRegionalToCampaign(textCampaignId);
        Long bmID5 = api.userSteps.bidModifiersSteps().addBidModifierVideoToCampaign(textCampaignId);
        Long bmID6 = api.userSteps.bidModifiersSteps().addBidModifierSerpLayoutToCampaign(textCampaignId);

        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(bmID1, bmID2, bmID3, bmID4, bmID5, bmID6)),
                ExpectedResult.success(),
                ExpectedResult.success(),
                ExpectedResult.success(),
                ExpectedResult.success(),
                ExpectedResult.success(),
                ExpectedResult.success()
        );
        List<BidModifierGetItem> bms =
                api.userSteps.bidModifiersSteps().bidModifiersGetById(bmID1, bmID2, bmID3, bmID4, bmID5);
        assertThat("корректировки ставок на кампанию удалены", bms, emptyIterable());
    }
}
