package ru.yandex.autotests.direct.api.bidmodifiers.delete;

import java.util.List;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.emptyIterable;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 31.07.15
 */
@Aqua.Test
@Features(BidModifiersFeatures.DELETE)
@Description("Проверка позитивных сценариев удаления корректировок ставок")
public class DeleteBidModifiersPositiveTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_DELETE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long groupID;
    private static Long campaignID;

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
    }

    @Test
    @Description("Удаление мобильной корректировки ставок")
    public void deleteMobileModifierTest() {
        Long bmID = api.userSteps.bidModifiersSteps().addBidModifierMobileToGroup(groupID);
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(bmID)),
                ExpectedResult.success());
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(bmID);
        assertThat("мобильная корректировка ставок удалена", bms, emptyIterable());
    }

    @Test
    @Description("Удаление демографической корректировки ставок")
    public void deleteDemographicsModifierTest() {
        Long bmID = api.userSteps.bidModifiersSteps().addBidModifierDemographicsToGroup(groupID);
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(bmID)),
                ExpectedResult.success());
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(bmID);
        assertThat("демографическая корректировка ставок удалена", bms, emptyIterable());
    }

    @Test
    @Description("Удаление корректировки ставок ретаргетинга")
    public void deleteRetargetingModifierTest() {
        Integer conditionId = api.userSteps.retargetingSteps().addRandomRetargetingCondition(client);
        Long bmID = api.userSteps.bidModifiersSteps().addBidModifierRetargetingToGroup(conditionId.longValue(), groupID);
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(bmID)),
                ExpectedResult.success());
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(bmID);
        assertThat("корректировка ставок ретаргетинга удалена", bms, emptyIterable());
    }

    @Test
    @Description("Удаление корректировки ставок на регион")
    public void deleteRegionalModifierTest() {
        Long bmID = api.userSteps.bidModifiersSteps().addBidModifierRegionalToCampaign(campaignID);
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(bmID)),
                ExpectedResult.success());
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(bmID);
        assertThat("корректировка ставок на регион удалена", bms, emptyIterable());
    }

    @Test
    @Description("Удаление видео корректировки ставок")
    public void deleteVideoModifierTest() {
        Long bmID = api.userSteps.bidModifiersSteps().addBidModifierVideoToGroup(groupID);
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(bmID)),
                ExpectedResult.success());
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(bmID);
        assertThat("видео корректировка ставок удалена", bms, emptyIterable());
    }

    @Test
    @Description("Удаление видео корректировки ставок на кампанию")
    public void deleteCampaignVideoModifierTest() {
        Long bmID = api.userSteps.bidModifiersSteps().addBidModifierVideoToCampaign(campaignID);
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(bmID)),
                ExpectedResult.success());
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(bmID);
        assertThat("видео корректировка ставок удалена", bms, emptyIterable());
    }

    @Test
    @Description("Удаление корректировки ставок на позицию")
    public void deleteSerpLayoutModifierTest() {
        Long bmID = api.userSteps.bidModifiersSteps().addBidModifierSerpLayoutToCampaign(campaignID);
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(bmID)),
                ExpectedResult.success());
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(bmID);
        assertThat("корректировка ставок на позицию удалена", bms, emptyIterable());
    }

}
