package ru.yandex.autotests.direct.api.bidmodifiers.delete;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.utils.AccessRightsErrorHelper.checkCatchingJavaAccessError;

/**
 * Created by chicos on 31.07.15
 */
@Aqua.Test
@Features(BidModifiersFeatures.GET)
@Description("Удаление корректировок ставок от имени внутренних ролей")
@RunWith(Parameterized.class)
public class DeleteBidModifiersRolesAccessTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String bmCreator;

    @Parameterized.Parameter(1)
    public String bmRemover;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameter(4)
    public Api5Error expectedJavaError;

    @Parameterized.Parameters(name = "creator = {0}, remover = {1}, client = {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Logins.MANAGER_DEFAULT, Logins.MANAGER_DEFAULT, BidModifiersLogins.SERV_CLIENT,
                        ExpectedResult.success(), null},
                {Logins.SUPER_LOGIN, Logins.PLACER, BidModifiersLogins.SINGLE_CLIENT_DELETE,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)},
                {Logins.SUPER_LOGIN, Logins.SUPPORT, BidModifiersLogins.SINGLE_CLIENT_DELETE,
                        ExpectedResult.success(), null},
                {Logins.SUPER_LOGIN, Logins.SUPER_LOGIN, BidModifiersLogins.SINGLE_CLIENT_DELETE,
                        ExpectedResult.success(), null},
                {Logins.SUPER_LOGIN, BidModifiersLogins.SINGLE_CLIENT_DELETE, BidModifiersLogins.SINGLE_CLIENT_DELETE,
                        ExpectedResult.success(), null},
                {Logins.SUPER_LOGIN, BidModifiersLogins.SINGLE_CLIENT_REP, BidModifiersLogins.SINGLE_CLIENT,
                        ExpectedResult.success(), null},
                {BidModifiersLogins.AGENCY_1, BidModifiersLogins.AGENCY_1, BidModifiersLogins.SUBCLIENT,
                        ExpectedResult.success(), null},
                {BidModifiersLogins.AGENCY_REP, BidModifiersLogins.AGENCY_REP, BidModifiersLogins.SUBCLIENT,
                        ExpectedResult.success(), null},
                {BidModifiersLogins.AGENCY_1, BidModifiersLogins.SUBCLIENT, BidModifiersLogins.SUBCLIENT,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)},
        });
    }

    private long bmId;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareBidModifier() {
        log.info("Сбросим использованные юниты");
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(bmRemover);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(bmCreator);

        log.info("Создадим кампанию, группу и корректировку ставок от имени " + bmCreator);
        api.as(bmCreator);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        long groupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, client);
        bmId = api.userSteps.bidModifiersSteps().addBidModifierDemographicsToGroup(client, groupId);
    }

    @Test
    public void deleteBidModifierRolesTest() {
        checkCatchingJavaAccessError(expectedJavaError,
                () -> api.as(bmRemover).userSteps.bidModifiersSteps().shouldGetResultOn(
                        client,
                        Action.DELETE,
                        new DeleteRequestMap()
                                .withSelectionCriteria(new IdsCriteriaMap()
                                        .withIds(bmId)),
                        expectedResult));
    }
}
