package ru.yandex.autotests.direct.api.bidmodifiers.delete;

import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.beans.JsonObject;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by chicos on 31.07.15
 */
@Aqua.Test
@Features(BidModifiersFeatures.DELETE)
@Stories(ApiStories.JSON5)
@Description("Валидация JSON-запроса при удалении корректировок ставок")
public class DeleteBidModifiersStructureNegativeJsonTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_DELETE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client).protocol(ProtocolType.JSON);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @Description("Массив в поле SelectionCriteria")
    public void arrayInSelectionCriteriaFieldTest() {
        JsonObject request = new JsonObject()
                .with(StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA), new Object[]{
                        new IdsCriteriaMap().withIds(0L).getBean()});

        api.userSteps.bidModifiersSteps().shouldGetJSONErrorOn(
                ServiceNames.BID_MODIFIERS,
                client,
                Action.DELETE,
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA))
        );
    }

    @Test
    @Description("Целое число вместо массива SelectionCriteria.Ids")
    public void notAnArrayInIdsFieldTest() {
        JsonObject request = new JsonObject()
                .with(StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA), new JsonObject()
                        .with(StringUtils.capitalize(IdsCriteriaMap.IDS), 0L));

        api.userSteps.bidModifiersSteps().shouldGetJSONErrorOn(
                ServiceNames.BID_MODIFIERS,
                client,
                Action.DELETE,
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        StringUtils.capitalize(IdsCriteriaMap.IDS)),
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        path(StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA),
                                StringUtils.capitalize(IdsCriteriaMap.IDS))));
    }

    @Test
    @Description("Строка в качестве элемента массива SelectionCriteria.Ids")
    public void stringInIdsArrayTest() {
        String value = "INVALID_VALUE";

        JsonObject request = new JsonObject()
                .with(StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA), new JsonObject()
                        .with(StringUtils.capitalize(IdsCriteriaMap.IDS), singletonList(value)));

        api.userSteps.bidModifiersSteps().shouldGetJSONErrorOn(
                ServiceNames.BID_MODIFIERS,
                client,
                Action.DELETE,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA),
                                StringUtils.capitalize(IdsCriteriaMap.IDS))));
    }

    @Test
    @Description("Массив внутри массива SelectionCriteria.Ids")
    public void arrayInIdsArrayTest() {
        JsonObject request = new JsonObject()
                .with(StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA), new JsonObject()
                        .with(StringUtils.capitalize(IdsCriteriaMap.IDS), new Long[][]{new Long[]{0L}}));

        api.userSteps.bidModifiersSteps().shouldGetJSONErrorOn(
                ServiceNames.BID_MODIFIERS,
                client,
                Action.DELETE,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA),
                                StringUtils.capitalize(IdsCriteriaMap.IDS))));
    }
}
