package ru.yandex.autotests.direct.api.bidmodifiers.delete;

import java.util.Arrays;

import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;


/**
 * Created by chicos on 31.07.15
 */
@Aqua.Test
@Features(BidModifiersFeatures.DELETE)
@Description("Проверка некорректной структуры запроса Delete")
public class DeleteBidModifiersStructureNegativeTest {

    private static final String CLIENT = BidModifiersLogins.SINGLE_CLIENT_DELETE;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void noSelectionCriteriaInRequestTest() {
        api.userSteps.bidModifiersSteps().shouldGetBidModifierErrorOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(null),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        "params",
                        StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA)),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA))
        );
    }

    @Test
    public void emptySelectionCriteriaIdsTest() {
        api.userSteps.bidModifiersSteps().shouldGetBidModifierErrorOn(
                Action.DELETE,
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA),
                        StringUtils.capitalize(IdsCriteriaMap.IDS)),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(StringUtils.capitalize(IdsCriteriaMap.IDS))));
    }

    @Test
    public void emptyArrayOfIdsTest() {
        int minElementsCount = 1;
        api.userSteps.bidModifiersSteps().shouldGetBidModifierErrorOn(
                Action.DELETE,
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds()),
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        StringUtils.capitalize(IdsCriteriaMap.IDS)),
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        path(StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA),
                                StringUtils.capitalize(IdsCriteriaMap.IDS)), minElementsCount));

    }

    @Test
    @Description(
            "Попытка удаления корректировок ставок, число которых в одном запросе превышает максимально допустимое - " +
                    IdsCriteriaMap.BID_MODIFIERS_IDS_MAX_LENGTH)
    public void deleteBidModifierOverlimitIdsTest() {
        Long[] fakeIds = new Long[IdsCriteriaMap.BID_MODIFIERS_IDS_MAX_LENGTH + 1];
        Arrays.fill(fakeIds, 0, IdsCriteriaMap.BID_MODIFIERS_IDS_MAX_LENGTH + 1, 123456L);

        api.userSteps.bidModifiersSteps().shouldGetBidModifierErrorOn(
                Action.DELETE,
                new DeleteRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(fakeIds)),
                new Api5Error(4001, Api5ErrorDetails.ARRAY_CANNOT_CONTAIN_MORE_THAN,
                        StringUtils.capitalize(IdsCriteriaMap.IDS),
                        IdsCriteriaMap.BID_MODIFIERS_IDS_MAX_LENGTH),
                new Api5Error(4001, Api5ErrorDetails.ARRAY_CANNOT_CONTAIN_MORE_THAN,
                        path(StringUtils.capitalize(DeleteRequestMap.SELECTION_CRITERIA),
                                StringUtils.capitalize(IdsCriteriaMap.IDS)),
                        IdsCriteriaMap.BID_MODIFIERS_IDS_MAX_LENGTH));
    }
}
