package ru.yandex.autotests.direct.api.bidmodifiers.delete;

import java.util.List;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import com.yandex.direct.api.v5.general.AgeRangeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DemographicsAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by proxeter on 01.02.16.
 *
 * https://st.yandex-team.ru/TESTIRT-8037
 */
@Aqua.Test
@Features(BidModifiersFeatures.DELETE)
@Description("Удаление ретаргетингового типа корректировки ставок для кампании типа ДТО")
public class DeleteDemographicBidModifiersForDynamicTextCampaignTest {

    private static final String LOGIN = BidModifiersLogins.SINGLE_CLIENT_DELETE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long groupId;
    private List<Long> addedBidModifiers;
    private AgeRangeEnum ageRange = AgeRangeEnum.AGE_0_17;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignId = api.as(LOGIN).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        groupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);

        addedBidModifiers = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .defaultBidModifier()
                        .withAdGroupId(groupId)
                        .withDemographicsAdjustment(
                                new DemographicsAdjustmentMap()
                                        .withDefaultBidModifier()
                                        .withAge(ageRange)
                        )
        );
        assumeThat("ретаргетинговая корректировка ставки установлена", addedBidModifiers, hasSize(1));
    }

    @Test
    public void deleteDemographicBidModifierForDTOCampaign() {
        api.userSteps.bidModifiersSteps().bidModifiersDelete(addedBidModifiers.stream().toArray(Long[]::new));

        List<BidModifierGetItem> result = api.userSteps.bidModifiersSteps().bidModifiersGetByAdGroupId(groupId);
        assumeThat("не найдена ни одна корректировка", result, hasSize(0));
    }
}
