package ru.yandex.autotests.direct.api.bidmodifiers.get;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.direct.utils.converter.EnumToStringValueConverter;

import static org.hamcrest.Matchers.containsInAnyOrder;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

public class GetBidModifierTestUtils {
    /**
     * Извлечь из бина все названия полей с ненулевыми значениями
     *
     * @return список названий полей
     */
    private static List<String> getNonNullFieldsNames(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(
                    "Необходимо передать объект для извлечения имен инициализированных полей");
        }
        return Arrays.stream(object.getClass().getDeclaredFields())
                .map(Field::getName)
                .map(StringUtils::capitalize)
                .filter(fieldName -> ReflectionUtils.invokeGetter(object, fieldName) != null)
                .collect(Collectors.toList());
    }

    /**
     * Проверить, что все ненулевые поля бина {@code object} соответствуют списку ожидаемых полей {@code expectedFields}
     */
    public static <C extends Collection<? extends Enum>> void assertThatObjectHasAllExpectedFields(Object object,
            C expectedFields)
    {
        EnumToStringValueConverter enumToStringConverter = new EnumToStringValueConverter();
        Set<String> expectedFieldNames = expectedFields.stream()
                .map(enumToStringConverter::convert)
                .collect(Collectors.toSet());
        assertThatObjectHasAllExpectedFieldNames(object, expectedFieldNames);
    }

    private static void assertThatObjectHasAllExpectedFieldNames(Object object, Collection<String> expectedFields) {
        List<String> gotFields = getNonNullFieldsNames(object);
        //exclude field duplicates
        Set<String> nonDuplicatedFields = new HashSet<>(expectedFields);
        assertThat("Получен объект с ожидаемым набором запрошенных полей", gotFields,
                containsInAnyOrder(nonDuplicatedFields.toArray()));
    }
}
