package ru.yandex.autotests.direct.api.bidmodifiers.get;

import java.util.List;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierLevelEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifiersSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static java.util.Collections.singletonList;
import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Features(BidModifiersFeatures.GET)
@Issue("DIRECT-84793")
public class GetBidModifiersCpmBannerTest {

    private static String LOGIN = BidModifiersLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long cpmBannerAdGroupId;
    private static Long cpmVideoAdGroupId;
    private static Long cpmBannerBmId;
    private static Long cpmVideoBmId;
    private static DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);

    @BeforeClass
    public static void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        cpmVideoAdGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(campaignId);
        cpmVideoBmId = api.userSteps.bidModifiersSteps().addBidModifierMobileToGroup(cpmVideoAdGroupId);
        dbSteps.adGroupsSteps().setType(cpmVideoAdGroupId, PhrasesAdgroupType.cpm_video);
        cpmBannerAdGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(campaignId);
        cpmBannerBmId = api.userSteps.bidModifiersSteps().addBidModifierMobileToGroup(cpmBannerAdGroupId);
    }

    @Test
    public void getWithCampaignId() {
        List<BidModifierGetItem> bidModifiers = api.userSteps.bidModifiersSteps().bidModifiersGet(LOGIN,
                new GetRequestMap().withSelectionCriteria(
                        new BidModifiersSelectionCriteriaMap()
                                .withCampaignIds(campaignId)
                                .withLevels(BidModifierLevelEnum.AD_GROUP))
                        .withFieldNames("Id"));

        assertThat("объект получен", bidModifiers,
                equalTo(asList(new BidModifierGetItemMap().withId(cpmVideoBmId).getBean(),
                        new BidModifierGetItemMap().withId(cpmBannerBmId).getBean())));
    }

    @Test
    public void getWithCpmBannerAdGroupId() {
        List<BidModifierGetItem> bidModifiers = api.userSteps.bidModifiersSteps().bidModifiersGet(LOGIN,
                new GetRequestMap().withSelectionCriteria(
                        new BidModifiersSelectionCriteriaMap()
                                .withAdGroupIds(cpmBannerAdGroupId)
                                .withLevels(BidModifierLevelEnum.AD_GROUP))
                        .withFieldNames("Id"));

        assertThat("объект получен", bidModifiers,
                beanDiffer(singletonList(new BidModifierGetItemMap().withId(cpmBannerBmId).getBean())));
    }

    @Test
    public void tryGetFromCpmVideoAdGroup_WithAdGroupId() {
        List<BidModifierGetItem> bidModifiers = api.userSteps.bidModifiersSteps().bidModifiersGet(LOGIN,
                new GetRequestMap().withSelectionCriteria(
                        new BidModifiersSelectionCriteriaMap()
                                .withAdGroupIds(cpmVideoAdGroupId)
                                .withLevels(BidModifierLevelEnum.AD_GROUP))
                        .withFieldNames("Id"));

        assertThat("объект получен", bidModifiers,
                beanDiffer(singletonList(new BidModifierGetItemMap().withId(cpmVideoBmId).getBean())));
    }

    @Test
    public void getWithCpmBannerBidModifierId() {
        List<BidModifierGetItem> bidModifiers = api.userSteps.bidModifiersSteps().bidModifiersGet(LOGIN,
                new GetRequestMap().withSelectionCriteria(
                        new BidModifiersSelectionCriteriaMap()
                                .withIds(cpmBannerBmId)
                                .withLevels(BidModifierLevelEnum.AD_GROUP))
                        .withFieldNames("Id"));

        assertThat("объект получен", bidModifiers,
                beanDiffer(singletonList(new BidModifierGetItemMap().withId(cpmBannerBmId).getBean())));
    }

    @Test
    public void tryGetFromCpmVideoAdGroup_WithBidModifierId() {
        List<BidModifierGetItem> bidModifiers = api.userSteps.bidModifiersSteps().bidModifiersGet(LOGIN,
                new GetRequestMap().withSelectionCriteria(
                        new BidModifiersSelectionCriteriaMap()
                                .withIds(cpmVideoBmId)
                                .withLevels(BidModifierLevelEnum.AD_GROUP))
                        .withFieldNames("Id"));

        assertThat("объект получен", bidModifiers,
                beanDiffer(singletonList(new BidModifierGetItemMap().withId(cpmVideoBmId).getBean())));
    }
}
