package ru.yandex.autotests.direct.api.bidmodifiers.get;


import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierLevelEnum;
import org.apache.commons.lang3.StringUtils;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifiersSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 14.07.15.
 */
@Aqua.Test
@Features(BidModifiersFeatures.GET)
@Description("Проверка валидации некорректных значений FieldNames")
@RunWith(Parameterized.class)
public class GetBidModifiersFieldNamesNegativeTest {
    private static LogSteps log = LogSteps.getLogger(GetBidModifiersFieldNamesNegativeTest.class);
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_GET;

    private static long bmID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String[] fieldNames;

    private static final String EXPECTED_FIELD_NAMES = "Id, CampaignId, AdGroupId, Level, Type";

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection fieldsValue() {
        prepareBidModifiers();
        Object[][] data = new Object[][]{
                {"Спецсимволы в имени поля", new String[]{"{InvalidNode}"}},
                {"Пустая строка", new String[]{""}},
                {"Поле с маленькой буквы", new String[]{"level"}},
                {"Несуществующее поле", new String[]{"NonExistingField"}},
                {"Корректное и несуществующее поля", new String[]{"Type", "NonExistingField"}}
        };
        return Arrays.asList(data);
    }

    private static void prepareBidModifiers() {
        log.info("Подготовим корректировку ставок");
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);

        bmID = api.userSteps.bidModifiersSteps().addBidModifierMobileToGroup(groupID);
    }

    @Test
    public void invalidFieldNamesTest() {
        api.userSteps.bidModifiersSteps().shouldGetBidModifierErrorOn(
                "Ожидалась другая ошибка при некорректных FieldNames",
                Action.GET,
                new GetRequestMap()
                        .withSelectionCriteria(new BidModifiersSelectionCriteriaMap()
                                .withIds(bmID)
                                .withLevels(BidModifierLevelEnum.AD_GROUP))
                        .withFieldNames(fieldNames),
                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        StringUtils.capitalize(GetRequestMap.FIELD_NAMES)),
                new Api5Error(8000, Api5ErrorDetailsJava.INCORRECT_ENUMERATE_VALUE_IN_ARRAY,
                        StringUtils.capitalize(GetRequestMap.FIELD_NAMES),
                        EXPECTED_FIELD_NAMES)
        );
    }
}
