package ru.yandex.autotests.direct.api.bidmodifiers.get;

import java.util.List;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierLevelEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.RetargetingCondition;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifiersSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static org.hamcrest.core.IsEqual.equalTo;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 12.08.15.
 */
@Aqua.Test
@Features(BidModifiersFeatures.GET)
@Tag(TagDictionary.TRUNK)
@Description("Проверка признака доступности цели в наборе корректировок ретаргетинга")
public class GetBidModifiersGoalAccessibleTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_GOAL_ACCESSIBLE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    private static Long bmId;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    @Step("Подготовим данные для теста")
    public void prepareBidModifier() {
        log.info("Подготовим корректировку ставок ретаргетинга для группы");
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        Integer conditionId = api.userSteps.retargetingSteps().addRandomRetargetingCondition(client);
        bmId = api.userSteps.bidModifiersSteps().addBidModifierRetargetingToGroup(conditionId.longValue(), groupID);

        log.info("Выставим признак доступности цели ретаргетинга в БД фейково");
        RetargetingCondition retargetingCondition = api.userSteps.retargetingSteps().getRetargetingCondition(conditionId);
        Long goalId = retargetingCondition.getRetargetingCondition()[0].getGoals()[0].getGoalID();
        int userShard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.getDirectJooqDbSteps().useShard(userShard).retargetingGoalsSteps()
                .setIsAccessible(conditionId.longValue(), goalId, 0);
    }

    @Test
    @Description("Получение признака доступности цели в корректировке ставок ретаргетинга")
    public void retargetingGoalAccessibleTest() {
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGet(
                new GetRequestMap()
                        .withSelectionCriteria(new BidModifiersSelectionCriteriaMap()
                                .withIds(bmId)
                                .withLevels(BidModifierLevelEnum.AD_GROUP))
                        .withFieldNames(BidModifierFieldEnum.ID)
                        .withAllRetargetingFieldNames()
        );
        assumeThat("получена корректировка ставок", bms, hasSize(1));
        assumeThat("получили набор корректировок ретаргетинга", bms.get(0).getRetargetingAdjustment(), notNullValue());

        assertThat("признак доступности целей условия ретаргетинга", bms.get(0).getRetargetingAdjustment().getAccessible(), equalTo(YesNoEnum.NO));
    }
}
