package ru.yandex.autotests.direct.api.bidmodifiers.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierLevelEnum;
import com.yandex.direct.api.v5.bidmodifiers.DemographicsAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.DemographicsAdjustmentGet;
import com.yandex.direct.api.v5.bidmodifiers.GetResponse;
import com.yandex.direct.api.v5.general.AgeRangeEnum;
import com.yandex.direct.api.v5.general.GenderEnum;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifiersSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DemographicsAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 30.07.15.
 */
@Aqua.Test
@Features(BidModifiersFeatures.GET)
@Description("Проверка выдачи nillable полей, когда значение поля не установленно при создании корректировки ставок")
@RunWith(Parameterized.class)
public class GetBidModifiersNillableFieldsTest {

    private static String client = BidModifiersLogins.SINGLE_CLIENT_GET;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public ProtocolType protocol;

    @Parameterized.Parameter(1)
    public DemographicsAdjustmentMap adjustment;

    @Parameterized.Parameter(2)
    public DemographicsAdjustmentFieldEnum fieldName;

    @Parameterized.Parameters(name = "protocol = {0}, field = {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {ProtocolType.JSON, new DemographicsAdjustmentMap()
                        .withGender(GenderEnum.GENDER_FEMALE)
                        .withDefaultBidModifier(),
                        DemographicsAdjustmentFieldEnum.AGE},
                {ProtocolType.JSON, new DemographicsAdjustmentMap()
                        .withAge(AgeRangeEnum.AGE_25_34)
                        .withDefaultBidModifier(),
                        DemographicsAdjustmentFieldEnum.GENDER},
                {ProtocolType.SOAP, new DemographicsAdjustmentMap()
                        .withGender(GenderEnum.GENDER_FEMALE)
                        .withDefaultBidModifier(),
                        DemographicsAdjustmentFieldEnum.AGE},
                {ProtocolType.SOAP, new DemographicsAdjustmentMap()
                        .withAge(AgeRangeEnum.AGE_25_34)
                        .withDefaultBidModifier(),
                        DemographicsAdjustmentFieldEnum.GENDER}

        });
    }

    private Long bmID;
    static Long groupId;

    @BeforeClass
    public static void initTest() {
        api.as(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void prepareBidModifier(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        List<Long> bmIds = api.protocol(protocol).userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withDemographicsAdjustment(adjustment)
                .withAdGroupId(groupId));
        assumeThat("создана демографическая корректировка", bmIds, hasSize(1));
        bmID = bmIds.get(0);
    }

    @After
    public void removeBidModifier(){
        api.userSteps.bidModifiersSteps().bidModifiersDelete(bmID);
    }

    @Test
    public void getNillableFieldTest() {
        GetResponse getResponse = api.userSteps.bidModifiersSteps().bidModifiersGetRawResponse(new GetRequestMap()
                .withSelectionCriteria(new BidModifiersSelectionCriteriaMap()
                        .withLevels(BidModifierLevelEnum.AD_GROUP)
                        .withIds(bmID))
                .withFieldNames(BidModifierFieldEnum.ID)
                .withDemographicsFieldNames(fieldName));
        assumeThat("получили корректировку ставок", getResponse.getBidModifiers(), hasSize(1));
        DemographicsAdjustmentGet demo = getResponse.getBidModifiers().get(0).getDemographicsAdjustment();
        assumeThat("получили демографический набор", demo, notNullValue());

        assertThat("корректное значение поля",
                ((JAXBElement) ReflectionUtils.invokeGetter(demo, fieldName.value())).getValue(),
                nullValue());
    }
}
