package ru.yandex.autotests.direct.api.bidmodifiers.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 29.07.15
 */
@Aqua.Test
@Features(BidModifiersFeatures.GET)
@Tag(TagDictionary.TRUNK)
@Description("Получение корректировок ставок от имени внутренних ролей")
@RunWith(Parameterized.class)
public class GetBidModifiersRolesAccessTest {
    private static LogSteps log = LogSteps.getLogger(GetBidModifiersRolesAccessTest.class);

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String bmCreator;

    @Parameterized.Parameter(1)
    public String bmGetter;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public Matcher expectedResult;

    @Parameterized.Parameters(name = "creator = {0}, getter = {1}, client = {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Logins.MANAGER_DEFAULT, Logins.MANAGER_DEFAULT, BidModifiersLogins.SERV_CLIENT,
                        hasSize(1)},
                {BidModifiersLogins.AGENCY_4, BidModifiersLogins.AGENCY_4, BidModifiersLogins.SUBCLIENT_1,
                        hasSize(1)},
                {BidModifiersLogins.AGENCY_REP, BidModifiersLogins.AGENCY_REP, BidModifiersLogins.SUBCLIENT,
                        hasSize(1)},
                {BidModifiersLogins.AGENCY_1, BidModifiersLogins.AGENCY_REP, BidModifiersLogins.SUBCLIENT,
                        hasSize(1)},
                {BidModifiersLogins.AGENCY_4, BidModifiersLogins.SUBCLIENT_1, BidModifiersLogins.SUBCLIENT_1,
                        hasSize(1)},

                {Logins.SUPER_LOGIN, Logins.PLACER, BidModifiersLogins.SINGLE_CLIENT_GET,
                        hasSize(1)},
                {Logins.SUPER_LOGIN, Logins.SUPPORT, BidModifiersLogins.SINGLE_CLIENT_GET,
                        hasSize(1)},
                {Logins.SUPER_LOGIN, Logins.SUPER_LOGIN, BidModifiersLogins.SINGLE_CLIENT_GET,
                        hasSize(1)},
                {Logins.SUPER_LOGIN, BidModifiersLogins.SINGLE_CLIENT_GET, BidModifiersLogins.SINGLE_CLIENT_GET,
                        hasSize(1)},
                {Logins.SUPER_LOGIN, BidModifiersLogins.SINGLE_CLIENT_REP, BidModifiersLogins.SINGLE_CLIENT,
                        hasSize(1)},
                {Logins.SUPER_LOGIN, Logins.MEDIA, BidModifiersLogins.SINGLE_CLIENT_GET,
                        hasSize(1)},
                {Logins.SUPER_LOGIN, Logins.SUPER_READER, BidModifiersLogins.SINGLE_CLIENT_GET,
                        hasSize(1)}
        });
    }

    private long bmID;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareGroup() {
        log.info("Сбросим использованные баллы");
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(bmGetter);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(bmCreator);

        log.info("Создадим кампанию, группу и корректировку от имени " + bmCreator);
        api.as(bmCreator);

        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, client);
        bmID = api.userSteps.bidModifiersSteps().addBidModifierDemographicsToGroup(client, groupID);
    }

    @Test
    public void getBidModifierRolesTest() {
        log.info("Запросим корректировку от имени " + bmGetter);
        api.as(bmGetter);
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(client, bmID);
        assertThat("получили корректировку ставок ролью", bms, expectedResult);
    }
}
