package ru.yandex.autotests.direct.api.bidmodifiers.get.demographics;


import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierLevelEnum;
import com.yandex.direct.api.v5.bidmodifiers.DemographicsAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.DemographicsAdjustmentGet;
import com.yandex.direct.api.v5.general.AgeRangeEnum;
import com.yandex.direct.api.v5.general.GenderEnum;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifiersSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DemographicsAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 22.07.15.
 */
@Aqua.Test
@Features(BidModifiersFeatures.GET)
@Tag(TagDictionary.TRUNK)
@Description("Проверка возможных значений поля Gender и Age")
@RunWith(Parameterized.class)
public class GetBidModifiersGenderAgeTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_GET;

    private static Long campaignID;

    private static Long bmID;

    private List<DemographicsAdjustmentGet> adjustments;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public GenderEnum gender;

    @Parameterized.Parameter(value = 1)
    public AgeRangeEnum age;

    @Parameterized.Parameters(name = "gender = {0}, age = {1}")
    public static Collection fieldsValue() {
        Object[][] data = new Object[][]{
                {GenderEnum.GENDER_MALE, null},
                {GenderEnum.GENDER_FEMALE, null},
                {null, AgeRangeEnum.AGE_0_17},
                {null, AgeRangeEnum.AGE_18_24},
                {null, AgeRangeEnum.AGE_25_34},
                {null, AgeRangeEnum.AGE_35_44},
                {null, AgeRangeEnum.AGE_45},
                {null, AgeRangeEnum.AGE_45_54},
                {null, AgeRangeEnum.AGE_55},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void prepareBidModifier() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withDemographicsAdjustment(new DemographicsAdjustmentMap()
                        .withGender(gender)
                        .withAge(age)
                        .withBidModifier(BidModifierAddMap.DEFAULT_BID_MODIFIER))
                .withCampaignId(campaignID));
        assumeThat("создана демографическая корректировка ставок", bmIds, hasSize(1));
        bmID = bmIds.get(0);

        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGet(
                new GetRequestMap()
                        .withSelectionCriteria(new BidModifiersSelectionCriteriaMap()
                                .withIds(bmID)
                                .withLevels(BidModifierLevelEnum.CAMPAIGN))
                        .withFieldNames(BidModifierFieldEnum.ID)
                        .withDemographicsFieldNames(
                                DemographicsAdjustmentFieldEnum.GENDER,
                                DemographicsAdjustmentFieldEnum.AGE));
        assumeThat("получены корректировки ставок", bms, hasSize(1));

        adjustments = extract(bms, on(BidModifierGetItem.class).getDemographicsAdjustment());
        assumeThat("получена демографическая корректировка", adjustments.get(0), notNullValue());
    }

    @Test
    public void genderTest() {
        assertThat("значение пола демографической корректировки", adjustments.get(0).getGender().getValue(),
                equalTo(gender));
    }

    @Test
    public void ageTest() {
        assertThat("значение возраста демографической корректировки", adjustments.get(0).getAge().getValue(),
                equalTo(age));
    }

    @After
    public void removeBidModifier() {
        api.userSteps.bidModifiersSteps().bidModifiersDelete(bmID);
    }
}
