package ru.yandex.autotests.direct.api.bidmodifiers.get.desktop;


import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierLevelEnum;
import com.yandex.direct.api.v5.bidmodifiers.DesktopAdjustmentFieldEnum;
import org.junit.AfterClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifiersSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DesktopAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.yandex.direct.api.v5.bidmodifiers.DesktopAdjustmentFieldEnum.BID_MODIFIER;
import static java.util.Arrays.asList;
import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.direct.api.bidmodifiers.get.GetBidModifierTestUtils.assertThatObjectHasAllExpectedFields;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(BidModifiersFeatures.GET)
@Description("Проверка выдачи при использовании фильтра по DesktopAdjustmentFieldNames")
@RunWith(Parameterized.class)
public class GetBidModifiersFieldNamesDesktopTest {
    private static LogSteps log = LogSteps.getLogger(GetBidModifiersFieldNamesDesktopTest.class);
    private static final String CLIENT = BidModifiersLogins.SINGLE_CLIENT_GET;

    private static Long campaignId;
    private static Long adGroupId;
    private static Long bidModifierId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter()
    public String description;

    @Parameterized.Parameter(value = 1)
    public String criteriaName;

    @Parameterized.Parameter(value = 2)
    public BidModifiersSelectionCriteriaMap criteria;

    @Parameterized.Parameter(value = 3)
    public List<DesktopAdjustmentFieldEnum> fieldNames;

    @Parameterized.Parameters(name = "criteria = {1}, test = {0}")
    public static Collection fieldsValue() {
        prepareBidModifiers();
        //noinspection ArraysAsListWithZeroOrOneArgument
        Object[][] data = new Object[][]{
                {"Поле bidModifier", "Id", new BidModifiersSelectionCriteriaMap().withIds(bidModifierId),
                        asList(BID_MODIFIER)},
                {"Поле bidModifier", "adGroupId", new BidModifiersSelectionCriteriaMap().withAdGroupIds(adGroupId),
                        asList(BID_MODIFIER)},
                {"Поле bidModifier", "campaignId", new BidModifiersSelectionCriteriaMap().withCampaignIds(campaignId),
                        asList(BID_MODIFIER)},
        };
        return asList(data);
    }

    private static void prepareBidModifiers() {
        log.info("Подготовим десктопные корректировки ставок");
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(campaignId);
        bidModifierId = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withAdGroupId(adGroupId)
                        .withDesktopAdjustment(new DesktopAdjustmentMap().defaultDesktopAdjustment())
        ).get(0);
    }

    @Test
    public void filedNamesTest() {
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGet(
                new GetRequestMap()
                        .withSelectionCriteria(criteria
                                .withLevels(BidModifierLevelEnum.AD_GROUP))
                        .withFieldNames(BidModifierFieldEnum.ID)
                        .withDesktopFieldNames((DesktopAdjustmentFieldEnum[]) fieldNames.toArray())
        );

        assumeThat("получены корректировки ставок", bms, hasSize(greaterThan(0)));

        log.info("Проверим набор десктопных корректировок на наличие запрошенных полей");
        bms.stream().map(BidModifierGetItem::getDesktopAdjustment)
                .forEach(item -> assertThatObjectHasAllExpectedFields(item, fieldNames));
    }

    @AfterClass
    public static void putCampaignToRemove() {
        //workaround для корректроного создания кампаний в параметризованном тесте
        api.userSteps.campaignSteps().putCampaignToQueue(CLIENT, campaignId);
    }
}
