package ru.yandex.autotests.direct.api.bidmodifiers.get.json;


import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierLevelEnum;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.beans.JsonObject;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifiersSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


/**
 * Created by chicos on 29.07.15.
 */
@Aqua.Test
@Features(BidModifiersFeatures.GET)
@Description("Валидация некорректных значений подставляемых вместо типа Array (AdGroupIds)")
@RunWith(Parameterized.class)
public class GetBidModifiersJsonValidationArrayTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_GET;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client).protocol(ProtocolType.JSON);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Object arrayValue;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection arrayValues() {
        Object[][] data = new Object[][]{
                {"Целое число вместо массива AdGroupIds", 1234L},
                {"Пустой объект вместо массива AdGroupIds", new JSONObject()},
                {"Вещественное число вместо массива AdGroupIds", 2.13F},
                {"Строка вместо массива AdGroupIds", "INVALID_VALUE"}
        };
        return Arrays.asList(data);
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void arrayValueTest() {
        JsonObject request = new JsonObject()
                .with(StringUtils.capitalize(GetRequestMap.SELECTION_CRITERIA), new JsonObject()
                        .with(StringUtils.capitalize(BidModifiersSelectionCriteriaMap.ADGROUP_IDS), arrayValue)
                        .with(StringUtils.capitalize(BidModifiersSelectionCriteriaMap.LEVELS), Arrays.asList(BidModifierLevelEnum.AD_GROUP)))
                .with(StringUtils.capitalize(GetRequestMap.FIELD_NAMES), Arrays.asList(
                        StringUtils.capitalize(BidModifierGetItemMap.ID),
                        StringUtils.capitalize(BidModifierGetItemMap.ADGROUP_ID)));

        api.userSteps.bidModifiersSteps().shouldGetJSONErrorOn(
                ServiceNames.BID_MODIFIERS,
                client,
                Action.GET,
                request,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        StringUtils.capitalize(BidModifiersSelectionCriteriaMap.ADGROUP_IDS)),
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        StringUtils.capitalize(GetRequestMap.SELECTION_CRITERIA) + "." + StringUtils.capitalize(BidModifiersSelectionCriteriaMap.ADGROUP_IDS)));
    }
}
