package ru.yandex.autotests.direct.api.bidmodifiers.get.json;


import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierLevelEnum;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.beans.JsonObject;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifiersSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


/**
 * Created by chicos on 29.07.15.
 */
@Aqua.Test
@Features(BidModifiersFeatures.GET)
@Description("Валидация некорректных значений вместо элемента Page")
@RunWith(Parameterized.class)
public class GetBidModifiersJsonValidationObjectTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_GET;

    private static long bmID;
    private static long groupID;
    private static Long campaignID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client).protocol(ProtocolType.JSON);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Object pageValue;

    @Parameterized.Parameter(value = 2)
    public Api5Error expectedError;

    @Parameterized.Parameter(value = 3)
    public Api5Error alternativeError;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection longValues() {
        Object[][] data = new Object[][]{
                {"Массив вместо элемента Page", Arrays.asList(1234L),
                        new Api5Error(8000,Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY, StringUtils.capitalize(GetRequestMap.PAGE)),
                        new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY, StringUtils.capitalize(GetRequestMap.PAGE))},
                {"Вещественное число вместо элемента Page", 2.13F,
                        new Api5Error(8000,Api5ErrorDetails.FIELD_MUST_CONTAIN_OBJECT, StringUtils.capitalize(GetRequestMap.PAGE)),
                        new Api5Error(8000, Api5ErrorDetailsJava.INVALID_VALUE, StringUtils.capitalize(GetRequestMap.PAGE))},
                {"Целое число вместо элемента Page", 1234L,
                        new Api5Error(8000,Api5ErrorDetails.FIELD_MUST_CONTAIN_OBJECT, StringUtils.capitalize(GetRequestMap.PAGE)),
                        new Api5Error(8000, Api5ErrorDetailsJava.INVALID_VALUE, StringUtils.capitalize(GetRequestMap.PAGE))}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareBidModifier() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        bmID = api.userSteps.bidModifiersSteps().addBidModifierDemographicsToGroup(groupID);
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void arrayValueTest() {
        JsonObject request = new JsonObject()
                .with(StringUtils.capitalize(GetRequestMap.SELECTION_CRITERIA), new JsonObject()
                        .with(StringUtils.capitalize(BidModifiersSelectionCriteriaMap.IDS), Arrays.asList(bmID))
                        .with(StringUtils.capitalize(BidModifiersSelectionCriteriaMap.LEVELS), Arrays.asList(BidModifierLevelEnum.AD_GROUP)))
                .with(StringUtils.capitalize(GetRequestMap.FIELD_NAMES), Arrays.asList(
                        StringUtils.capitalize(BidModifierGetItemMap.ID),
                        StringUtils.capitalize(BidModifierGetItemMap.ADGROUP_ID)))
                .with(StringUtils.capitalize(GetRequestMap.PAGE), pageValue);

        api.userSteps.bidModifiersSteps().shouldGetJSONErrorOn(
                ServiceNames.BID_MODIFIERS,
                client,
                Action.GET,
                request,
                expectedError,
                alternativeError);
    }
}
