package ru.yandex.autotests.direct.api.bidmodifiers.get.mobile;


import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierLevelEnum;
import com.yandex.direct.api.v5.bidmodifiers.MobileAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.MobileAdjustmentGet;
import org.junit.AfterClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifiersSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static java.util.Arrays.asList;
import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.direct.api.bidmodifiers.get.GetBidModifierTestUtils.assertThatObjectHasAllExpectedFields;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 14.07.15.
 */
@Aqua.Test
@Features(BidModifiersFeatures.GET)
@Description("Проверка выдачи при использовании фильтра по MobileAdjustmentFieldNames")
@RunWith(Parameterized.class)
public class GetBidModifiersFieldNamesMobileTest {
    private static LogSteps log = LogSteps.getLogger(GetBidModifiersFieldNamesMobileTest.class);
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_GET;

    private static Long campaignId;
    private static Long groupId;

    private static Long bmId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter()
    public String description;

    @Parameterized.Parameter(value = 1)
    public String criteriaName;

    @Parameterized.Parameter(value = 2)
    public BidModifiersSelectionCriteriaMap criteria;

    @Parameterized.Parameter(value = 3)
    public List<MobileAdjustmentFieldEnum> fieldNames;

    @Parameterized.Parameters(name = "criteria = {1}, test = {0}")
    public static Collection fieldsValue() {
        prepareBidModifiers();
        //noinspection ArraysAsListWithZeroOrOneArgument
        Object[][] data = new Object[][]{
                {"Поле bidModifier", "Id", new BidModifiersSelectionCriteriaMap().withIds(bmId),
                        asList(MobileAdjustmentFieldEnum.BID_MODIFIER)},
                {"Поле bidModifier", "adGroupId", new BidModifiersSelectionCriteriaMap().withAdGroupIds(groupId),
                        asList(MobileAdjustmentFieldEnum.BID_MODIFIER)},
                {"Поле bidModifier", "campaignId", new BidModifiersSelectionCriteriaMap().withCampaignIds(campaignId),
                        asList(MobileAdjustmentFieldEnum.BID_MODIFIER)},
        };
        return asList(data);
    }

    private static void prepareBidModifiers() {
        log.info("Подготовим мобильные корректировки ставок");
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        bmId = api.userSteps.bidModifiersSteps().addBidModifierMobileToGroup(groupId);
    }

    @Test
    public void filedNamesTest() {
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGet(
                new GetRequestMap()
                        .withSelectionCriteria(criteria
                                .withLevels(BidModifierLevelEnum.AD_GROUP))
                        .withFieldNames(BidModifierFieldEnum.ID)
                        .withMobileFieldNames((MobileAdjustmentFieldEnum[]) fieldNames.toArray())
        );

        assumeThat("получены корректировки ставок", bms, hasSize(greaterThan(0)));
        List<MobileAdjustmentGet> mobileAdjustments = extract(bms, on(BidModifierGetItem.class).getMobileAdjustment());

        log.info("Проверим набор мобильных корректировок на наличие запрошенных полей");
        for (MobileAdjustmentGet item : mobileAdjustments) {
            assertThatObjectHasAllExpectedFields(item, fieldNames);
        }
    }

    @AfterClass
    public static void putCampaignToRemove() {
        //workaround для корректроного создания кампаний в параметризованном тесте
        api.userSteps.campaignSteps().putCampaignToQueue(client, campaignId);
    }
}
