package ru.yandex.autotests.direct.api.bidmodifiers.get.mobile;


import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierLevelEnum;
import com.yandex.direct.api.v5.bidmodifiers.MobileAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.OperatingSystemTypeEnum;
import org.junit.AfterClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifiersSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.MobileAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.yandex.direct.api.v5.bidmodifiers.MobileAdjustmentFieldEnum.BID_MODIFIER;
import static com.yandex.direct.api.v5.bidmodifiers.MobileAdjustmentFieldEnum.OPERATING_SYSTEM_TYPE;
import static java.util.Arrays.asList;
import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.direct.api.bidmodifiers.get.GetBidModifierTestUtils.assertThatObjectHasAllExpectedFields;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(BidModifiersFeatures.GET)
@Description("Проверка выдачи при использовании фильтра по MobileAdjustmentFieldNames")
@RunWith(Parameterized.class)
public class GetBidModifiersFieldNamesMobileWithOsTypeTest {
    private static LogSteps log = LogSteps.getLogger(GetBidModifiersFieldNamesMobileWithOsTypeTest.class);
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_GET;

    private static Long campaignId;
    private static Long adGroupId;
    private static Long bidModifierId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter()
    public String description;

    @Parameterized.Parameter(value = 1)
    public String criteriaName;

    @Parameterized.Parameter(value = 2)
    public BidModifiersSelectionCriteriaMap criteria;

    @Parameterized.Parameter(value = 3)
    public List<MobileAdjustmentFieldEnum> fieldNames;

    @Parameterized.Parameters(name = "criteria = {1}, test = {0}")
    public static Collection fieldsValue() {
        prepareBidModifiers();
        //noinspection ArraysAsListWithZeroOrOneArgument
        Object[][] data = new Object[][]{
                {"Поле bidModifier", "Id", new BidModifiersSelectionCriteriaMap().withIds(bidModifierId),
                        asList(BID_MODIFIER)},
                {"Поле bidModifier", "adGroupId", new BidModifiersSelectionCriteriaMap().withAdGroupIds(adGroupId),
                        asList(BID_MODIFIER)},
                {"Поле bidModifier", "campaignId", new BidModifiersSelectionCriteriaMap().withCampaignIds(campaignId),
                        asList(BID_MODIFIER)},
                {"Поле operatingSystemType", "Id", new BidModifiersSelectionCriteriaMap().withIds(bidModifierId),
                        asList(OPERATING_SYSTEM_TYPE)},
                {"Поле operatingSystemType", "adGroupId",
                        new BidModifiersSelectionCriteriaMap().withAdGroupIds(adGroupId),
                        asList(OPERATING_SYSTEM_TYPE)},
                {"Поле operatingSystemType", "campaignId",
                        new BidModifiersSelectionCriteriaMap().withCampaignIds(campaignId),
                        asList(OPERATING_SYSTEM_TYPE)},
                {"Поле bidModifier, operatingSystemType", "campaignId",
                        new BidModifiersSelectionCriteriaMap().withCampaignIds(campaignId),
                        asList(BID_MODIFIER, OPERATING_SYSTEM_TYPE)},
        };
        return asList(data);
    }

    private static void prepareBidModifiers() {
        log.info("Подготовим мобильные корректировки ставок");
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(campaignId);
        bidModifierId = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withAdGroupId(adGroupId)
                        .withMobileAdjustment(
                                new MobileAdjustmentMap().defaultMobileAdjustment()
                                        .withOperatingSystemType(OperatingSystemTypeEnum.IOS))
        ).get(0);
    }

    @Test
    public void filedNamesTest() {
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGet(
                new GetRequestMap()
                        .withSelectionCriteria(criteria
                                .withLevels(BidModifierLevelEnum.AD_GROUP))
                        .withFieldNames(BidModifierFieldEnum.ID)
                        .withMobileFieldNames((MobileAdjustmentFieldEnum[]) fieldNames.toArray())
        );

        assumeThat("получены корректировки ставок", bms, hasSize(greaterThan(0)));

        log.info("Проверим набор мобильных корректировок на наличие запрошенных полей");
        bms.stream().map(BidModifierGetItem::getMobileAdjustment)
                .forEach(item -> assertThatObjectHasAllExpectedFields(item, fieldNames));
    }

    @AfterClass
    public static void putCampaignToRemove() {
        //workaround для корректроного создания кампаний в параметризованном тесте
        api.userSteps.campaignSteps().putCampaignToQueue(client, campaignId);
    }
}
