package ru.yandex.autotests.direct.api.bidmodifiers.set;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierSetMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 08.08.15.
 */
@Aqua.Test
@Features(BidModifiersFeatures.SET)
@Tag(TagDictionary.TRUNK)
@Description("Проверка доступа агентства к корректировкам ставок субклиента при модификации")
public class SetBidModifiersAgencyAccessTest {
    private static final String singleClient = BidModifiersLogins.SINGLE_CLIENT_SET;

    private static final String agency = BidModifiersLogins.AGENCY_4;
    private static final String subclient1 = BidModifiersLogins.SUBCLIENT_1;
    private static final String subclient2 = BidModifiersLogins.SUBCLIENT_2;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
    }

    @Test
    @Description("Модифицируем агентством корректировку ставок созданную сублиентом")
    public void setBidModifierByAgencyTest() {
        Long campaignID = api.as(subclient1).userSteps.campaignSteps().addDefaultTextCampaign(subclient1);
        Long bmID = api.userSteps.bidModifiersSteps().addBidModifierMobileToCampaign(campaignID);
        api.as(agency).userSteps.bidModifiersSteps().shouldGetResultOn(
                subclient1,
                Action.SET,
                new SetRequestMap().withBidModifiers(new BidModifierSetMap()
                        .defaultBidModifier()
                        .withId(bmID)),
                ExpectedResult.success());
    }

    @Test
    @Description("Модифицируем агентством корректировку ставок субклиенту, указав корректировку другого сублиента")
    public void anotherSubсlientModifierTest() {
        Long campaignID = api.as(subclient2).userSteps.campaignSteps().addDefaultTextCampaign(subclient2);
        Long bmID = api.userSteps.bidModifiersSteps().addBidModifierMobileToCampaign(campaignID);
        api.as(agency).userSteps.bidModifiersSteps().shouldGetResultOn(
                subclient1,
                Action.SET,
                new SetRequestMap().withBidModifiers(new BidModifierSetMap()
                        .defaultBidModifier()
                        .withId(bmID)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.BID_MODIFIER_NOT_FOUND)));
    }

    @Test
    @Description("Модифицируем агентством корректировку ставок субклиенту, указав свою корректировку и корректировку другого сублиента")
    public void ownedModifierAndAnotherSubсlientModifierTest() {
        Long campaignID1 = api.as(subclient1).userSteps.campaignSteps().addDefaultTextCampaign(subclient1);
        Long bmID1 = api.userSteps.bidModifiersSteps().addBidModifierMobileToCampaign(campaignID1);
        Long campaignID2 = api.as(subclient2).userSteps.campaignSteps().addDefaultTextCampaign(subclient2);
        Long bmID2 = api.userSteps.bidModifiersSteps().addBidModifierMobileToCampaign(campaignID2);
        api.as(agency).userSteps.bidModifiersSteps().shouldGetResultOn(
                subclient1,
                Action.SET,
                new SetRequestMap().withBidModifiers(
                        new BidModifierSetMap()
                                .defaultBidModifier()
                                .withId(bmID1),
                        new BidModifierSetMap()
                                .defaultBidModifier()
                                .withId(bmID2)),
                ExpectedResult.success(),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.BID_MODIFIER_NOT_FOUND)));
    }

    @Test
    @Description("Модифицируем агентством корректировку ставок субклиенту, указав корректировку самостоятельного клиента")
    public void nonOwnedModifierByAgencyTest() {
        Long campaignID = api.as(singleClient).userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
        Long bmID = api.userSteps.bidModifiersSteps().addBidModifierMobileToCampaign(campaignID);
        api.as(agency).userSteps.bidModifiersSteps().shouldGetResultOn(
                subclient1,
                Action.SET,
                new SetRequestMap().withBidModifiers(new BidModifierSetMap()
                        .defaultBidModifier()
                        .withId(bmID)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.BID_MODIFIER_NOT_FOUND)));
    }
}
