package ru.yandex.autotests.direct.api.bidmodifiers.set;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierSetMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;

/**
 * Created by chicos on 08.08.15
 */
@Aqua.Test
@Features(BidModifiersFeatures.SET)
@Tag(TagDictionary.TRUNK)
@Description("Запрос на модификацию корректировок с указанием невалидных идентификаторов")
@RunWith(Parameterized.class)
public class SetBidModifiersInvalidIdsTest {

    private static final String client = BidModifiersLogins.SINGLE_CLIENT_SET;
    private static final String anotherClient = BidModifiersLogins.SINGLE_CLIENT_ANOTHER;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long bmDeleted;
    private static Long bmAnother;
    @Rule
    public Trashman trasher = new Trashman(api);
    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String operator;

    @Parameterized.Parameter(2)
    public Long bmID;

    @Parameterized.Parameter(3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameter(4)
    public ExpectedResult alternativeResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection<Object[]> data() {
        prepareBidModifiers();
        return Arrays.asList(new Object[][]{
                {"Нулевой ID корректировки", client, 0L,
                        ExpectedResult.errors(new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                StringUtils.capitalize(BidModifierSetMap.ID))),
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                                        StringUtils.capitalize(BidModifierSetMap.ID)))},
                {"Отрицательный ID корректировки", client, -1L,
                        ExpectedResult.errors(new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                StringUtils.capitalize(BidModifierSetMap.ID))),
                        ExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                                        StringUtils.capitalize(BidModifierSetMap.ID)))},
                {"Несуществующая корректировка ставок", client, 123456L,
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.BID_MODIFIER_NOT_FOUND)),
                        null},
                {"Удаленная корректировка ставок", client, bmDeleted,
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.BID_MODIFIER_NOT_FOUND)),
                        null},
                {"Чужая корректировка ставок", client, bmAnother,
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.BID_MODIFIER_NOT_FOUND)),
                        null},
        });
    }

    private static void prepareBidModifiers() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(anotherClient);

        api.as(anotherClient);
        Long anotherCampaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(anotherClient);
        bmAnother =
                api.userSteps.bidModifiersSteps().addBidModifierDemographicsToCampaign(anotherCampaignID.intValue());

        api.as(client);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        bmDeleted = api.userSteps.bidModifiersSteps().addBidModifierDemographicsToCampaign(campaignID.intValue());
        api.userSteps.bidModifiersSteps().bidModifiersDelete(bmDeleted);
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void invalidIdsTest() {
        api.as(operator).userSteps.bidModifiersSteps().shouldGetEitherResultOn(
                Action.SET,
                new SetRequestMap().withBidModifiers(
                        new BidModifierSetMap()
                                .defaultBidModifier()
                                .withId(bmID)),
                singletonList(expectedResult),
                alternativeResult == null ? null : singletonList(alternativeResult));
    }
}
