package ru.yandex.autotests.direct.api.bidmodifiers.set;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierSetMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 07.08.15
 */
@Aqua.Test
@Features(BidModifiersFeatures.SET)
@Description("Проверка негативных сценариев модификации корректировок ставок")
public class SetBidModifiersNegativeTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_SET;

    private static Long bmArchivedID;
    private static Long bmID;

    private static long bmID1;
    private static long bmID2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepareBidModifiers() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignArchived = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        bmArchivedID = api.userSteps.bidModifiersSteps().addBidModifierMobileToCampaign(campaignArchived);
        api.userSteps.campaignSteps().campaignsSuspend(campaignArchived);
        api.userSteps.campaignSteps().campaignsArchive(campaignArchived);

        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        bmID = api.userSteps.bidModifiersSteps().addBidModifierDemographicsToCampaign(campaignID.intValue());

        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        bmID1 = api.userSteps.bidModifiersSteps().addBidModifierDemographicsToGroup(groupID);
        bmID2 = api.userSteps.bidModifiersSteps().addBidModifierMobileToGroup(groupID);
    }

    @Test
    @Description("Попробуем модифицировать корректировку ставки из архивной кампании")
    public void archivedCampaignTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.SET,
                new SetRequestMap().withBidModifiers(
                        new BidModifierSetMap()
                                .defaultBidModifier()
                                .withId(bmArchivedID)),
                ExpectedResult.errors(new Notification(8300, Api5ErrorDetails.UNABLE_UPDATE_ARCHIVED_CAMPAGN)));
    }

    @Test
    @Description("Модификация двух корректировок ставок, идентификатор одной из которых - некорректен")
    public void setMultipleBidModifiersOneInvalidTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.SET,
                new SetRequestMap().withBidModifiers(
                        new BidModifierSetMap()
                                .defaultBidModifier()
                                .withId(bmID),
                        new BidModifierSetMap()
                                .defaultBidModifier()
                                .withId(123456L)),
                ExpectedResult.success(bmID),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.BID_MODIFIER_NOT_FOUND)));
    }

    @Test
    @Description("Две однинаковых корректировки ставок в запросе")
    public void sameModifiersInRequestTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.SET,
                new SetRequestMap().withBidModifiers(
                        new BidModifierSetMap()
                                .defaultBidModifier()
                                .withId(bmID1),
                        new BidModifierSetMap()
                                .defaultBidModifier()
                                .withId(bmID1),
                        new BidModifierSetMap()
                                .defaultBidModifier()
                                .withId(bmID2)),
                ExpectedResult.errors(new Notification(9800, Api5ErrorDetails.BID_MODIFIER_COULD_NOT_BE_PRESENTED_MORE_THAN_ONCE)),
                ExpectedResult.errors(new Notification(9800, Api5ErrorDetails.BID_MODIFIER_COULD_NOT_BE_PRESENTED_MORE_THAN_ONCE)),
                ExpectedResult.success(bmID2));
    }

    @Test
    @Description("Разные значения для одной корректировки ставок в запросе")
    public void differentValuesForBidModifierInRequestTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.SET,
                new SetRequestMap().withBidModifiers(
                        new BidModifierSetMap()
                                .withBidModifier(113)
                                .withId(bmID1),
                        new BidModifierSetMap()
                                .withBidModifier(114)
                                .withId(bmID1)),
                ExpectedResult.errors(new Notification(9800, Api5ErrorDetails.BID_MODIFIER_COULD_NOT_BE_PRESENTED_MORE_THAN_ONCE)),
                ExpectedResult.errors(new Notification(9800, Api5ErrorDetails.BID_MODIFIER_COULD_NOT_BE_PRESENTED_MORE_THAN_ONCE)));
    }

}
