package ru.yandex.autotests.direct.api.bidmodifiers.set;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierSetMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RegionalAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/DIRECT-64099
 */
@Aqua.Test
@Features(BidModifiersFeatures.SET)
@Description("Проверка допустимого диапазона корректировок ставок при модификации")
@RunWith(Parameterized.class)
public class SetBidModifiersRegionalRangeTest {
    private static final String LOGIN = BidModifiersLogins.SINGLE_CLIENT_SET;

    private Long bmID;
    private static Integer regionId1 = RegionIDValues.SPB.getId();
    private static Integer regionId2 = RegionIDValues.MOSCOW.getId();
    private static Integer regionId3 = RegionIDValues.BELARUS.getId();
    private static Integer regionId4 = RegionIDValues.GERMANY.getId();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long campaignId;

    @Parameterized.Parameter(2)
    public RegionalAdjustmentMap regionalAdjustmentMap;

    @Parameterized.Parameter(3)
    public Integer newModifierValue;

    @Parameterized.Parameter(4)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection<Object[]> data() {
        Long textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long dynamicCampaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long mobileCampaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        return Arrays.asList(new Object[][]{
                {"Региональный - значение меньше минимального для мобильной кампании", mobileCampaignId,
                        new RegionalAdjustmentMap()
                                .withDefaultBidModifier().withRegionId(regionId1),
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MIN - 1,
                        ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_LESS,
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MIN))},
                {"Региональный - минимальное значение для мобильной кампании", mobileCampaignId,
                        new RegionalAdjustmentMap()
                                .withDefaultBidModifier().withRegionId(regionId2),
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MIN,
                        ExpectedResult.success()},
                {"Региональный - максимальное значение для мобильной кампании", mobileCampaignId,
                        new RegionalAdjustmentMap()
                                .withDefaultBidModifier().withRegionId(regionId3),
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MAX,
                        ExpectedResult.success()},
                {"Региональный - значение больше максимального для мобильной кампании", mobileCampaignId,
                        new RegionalAdjustmentMap()
                                .withDefaultBidModifier().withRegionId(regionId4),
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MAX + 1,
                        ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_MORE,
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MAX))},

                {"Региональный - значение меньше минимального для динамической кампании", dynamicCampaignId,
                        new RegionalAdjustmentMap()
                                .withDefaultBidModifier().withRegionId(regionId1),
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MIN - 1,
                        ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_LESS,
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MIN ))},
                {"Региональный - минимальное значение для динамической кампании", dynamicCampaignId,
                        new RegionalAdjustmentMap()
                                .withDefaultBidModifier().withRegionId(regionId2),
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MIN,
                        ExpectedResult.success()},
                {"Региональный - максимальное значение для динамической кампании", dynamicCampaignId,
                        new RegionalAdjustmentMap()
                                .withDefaultBidModifier().withRegionId(regionId3),
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MAX,
                        ExpectedResult.success()},
                {"Региональный - значение больше максимального для динамической кампании", dynamicCampaignId,
                        new RegionalAdjustmentMap()
                                .withDefaultBidModifier().withRegionId(regionId4),
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MAX + 1,
                        ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_MORE,
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MAX))},

                {"Региональный - значение меньше минимального для текстовой кампании", textCampaignId,
                        new RegionalAdjustmentMap()
                                .withDefaultBidModifier().withRegionId(regionId1),
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MIN - 1,
                        ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_LESS,
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MIN ))},
                {"Региональный - минимальное значение для текстовой кампании", textCampaignId,
                        new RegionalAdjustmentMap()
                                .withDefaultBidModifier().withRegionId(regionId2),
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MIN,
                        ExpectedResult.success()},
                {"Региональный - максимальное значение для текстовой кампании", textCampaignId,
                        new RegionalAdjustmentMap()
                                .withDefaultBidModifier().withRegionId(regionId3),
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MAX,
                        ExpectedResult.success()},
                {"Региональный - значение больше максимального для текстовой кампании", textCampaignId,
                        new RegionalAdjustmentMap()
                                .withDefaultBidModifier().withRegionId(regionId4),
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MAX + 1,
                        ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_MORE,
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MAX))},
        });
    }

    @Before
    public void chooseCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        List<Long> bmIDs = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withRegionalAdjustment(regionalAdjustmentMap)
                        .withCampaignId(campaignId));
        assumeThat("создана корректировка ставок", bmIDs, hasSize(1));
        bmID = bmIDs.get(0);
    }

    @Test
    public void bidModifierRangeTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.SET,
                new SetRequestMap().withBidModifiers(new BidModifierSetMap()
                        .withId(bmID)
                        .withBidModifier(newModifierValue)),
                expectedResult);
    }
}
