package ru.yandex.autotests.direct.api.bidmodifiers.set;

import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierSetMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 08.08.15
 */
@Aqua.Test
@Features(BidModifiersFeatures.SET)
@Description("Запросы на модификацию BidModifier по протоколу SOAP")
public class SetBidModifiersSoapTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_SET;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client).protocol(ProtocolType.SOAP);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void noBidModifiersInRequestTest() {
        api.userSteps.bidModifiersSteps().shouldGetBidModifierErrorOn(
                Action.SET,
                new SetRequestMap(),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        StringUtils.capitalize(SetRequestMap.BID_MODIFIERS)));
    }

    @Test
    @Description("Валидный запрос на модификацию корректировки ставки")
    public void setBidModifierPositiveTest() {
        api.protocol(ProtocolType.JSON);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        long bmID = api.userSteps.bidModifiersSteps().addBidModifierMobileToGroup(groupID);

        api.protocol(ProtocolType.SOAP);
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.SET,
                new SetRequestMap().withBidModifiers(
                        new BidModifierSetMap()
                                .defaultBidModifier()
                                .withId(bmID)),
                ExpectedResult.success(bmID));
    }
}
