package ru.yandex.autotests.direct.api.bidmodifiers.set;

import java.util.Arrays;

import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.beans.JsonObject;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierSetMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 08.08.15
 */
@Aqua.Test
@Features(BidModifiersFeatures.SET)
@Stories(ApiStories.JSON5)
@Description("Валидация JSON-запроса при модификации корректировок ставок")
public class SetBidModifiersStructureNegativeJsonTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_SET;

    private static Long campaignID;
    private static Long bmID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client).protocol(ProtocolType.JSON);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void prepareBidModifier() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        bmID = api.userSteps.bidModifiersSteps().addBidModifierMobileToCampaign(campaignID);
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @Description("Строка вместо элемента BidModifiers.BidModifier")
    public void stringInBidModifierValueTest() {
        String value = "INVALID_VALUE";
        JsonObject request = new JsonObject()
                .with(StringUtils.capitalize(SetRequestMap.BID_MODIFIERS), Arrays.asList(new JsonObject()
                        .with(StringUtils.capitalize(BidModifierSetMap.ID), bmID)
                        .with(StringUtils.capitalize(BidModifierSetMap.BID_MODIFIER), value)));

        api.userSteps.bidModifiersSteps().shouldGetJSONErrorOn(
                ServiceNames.BID_MODIFIERS,
                client,
                Action.SET,
                request,
                JavaOrPerlApi5Error.java(
                        new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                                StringUtils.capitalize(SetRequestMap.BID_MODIFIERS) + "." +
                                        StringUtils.capitalize(BidModifierSetMap.BID_MODIFIER)))
                        .perl(
                                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                                        StringUtils.capitalize(BidModifierSetMap.BID_MODIFIER))
                        ));
    }

    @Test
    @Description("Строка вместо элемента BidModifiers.Id")
    public void stringInIdTest() {
        String value = "INVALID_VALUE";
        JsonObject request = new JsonObject()
                .with(StringUtils.capitalize(SetRequestMap.BID_MODIFIERS), Arrays.asList(new JsonObject()
                        .with(StringUtils.capitalize(BidModifierSetMap.ID), value)
                        .with(StringUtils.capitalize(BidModifierSetMap.BID_MODIFIER), 120)));

        api.userSteps.bidModifiersSteps().shouldGetJSONErrorOn(
                ServiceNames.BID_MODIFIERS,
                client,
                Action.SET,
                request,
                JavaOrPerlApi5Error.java(
                        new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                                StringUtils.capitalize(SetRequestMap.BID_MODIFIERS) + "." +
                                        StringUtils.capitalize(BidModifierSetMap.ID)))
                        .perl(
                                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                                        StringUtils.capitalize(BidModifierSetMap.ID))
                        ));
    }

    @Test
    @Description("Массив вместо элемента BidModifiers.Id")
    public void arrayInIdTest() {
        JsonObject request = new JsonObject()
                .with(StringUtils.capitalize(SetRequestMap.BID_MODIFIERS), Arrays.asList(new JsonObject()
                        .with(StringUtils.capitalize(BidModifierSetMap.ID), new Long[]{bmID})
                        .with(StringUtils.capitalize(BidModifierSetMap.BID_MODIFIER), 120)));

        api.userSteps.bidModifiersSteps().shouldGetJSONErrorOn(
                ServiceNames.BID_MODIFIERS,
                client,
                Action.SET,
                request,
                JavaOrPerlApi5Error.java(
                        new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                StringUtils.capitalize(SetRequestMap.BID_MODIFIERS) + "." +
                                        StringUtils.capitalize(BidModifierSetMap.ID)))
                        .perl(
                                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                        StringUtils.capitalize(BidModifierSetMap.ID))
                        ));
    }

    @Test
    @Description("Массив целых чисел вместо массива элементов BidModifierSetItem")
    public void integerArrayInBidModifiersTest() {
        api.userSteps.bidModifiersSteps().shouldGetJSONErrorOn(
                ServiceNames.BID_MODIFIERS,
                null,
                Action.SET,
                new JsonObject()
                        .with(StringUtils.capitalize(SetRequestMap.BID_MODIFIERS), Arrays.asList(123, 456, 789)),
                JavaOrPerlApi5Error.java(
                        new Api5Error(8000, Api5ErrorDetailsJava.INVALID_VALUE,
                                StringUtils.capitalize(SetRequestMap.BID_MODIFIERS)))
                        .perl(
                                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_MUST_CONTAIN_OBJECT,
                                        StringUtils.capitalize(SetRequestMap.BID_MODIFIERS))
                        ));
    }

    @Test
    @Description("Объект вместо массива элементов BidModifierSetItem")
    public void objectInBidModifiersArrayTest() {
        api.userSteps.bidModifiersSteps().shouldGetBidModifierErrorJsonOn(
                Action.SET,
                new JsonObject()
                        .with(StringUtils.capitalize(SetRequestMap.BID_MODIFIERS), new JsonObject()),
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        StringUtils.capitalize(SetRequestMap.BID_MODIFIERS)));
    }

    @Test
    public void noIdInRequestTest() {
        api.userSteps.bidModifiersSteps().shouldGetJSONErrorOn(
                ServiceNames.BID_MODIFIERS,
                client,
                Action.SET,
                new JsonObject()
                        .with(StringUtils.capitalize(SetRequestMap.BID_MODIFIERS), new Object[]{
                                new JsonObject()
                                        .with(StringUtils.capitalize(BidModifierSetMap.BID_MODIFIER), 120)}),
                new Api5Error(8000, Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        StringUtils.capitalize(SetRequestMap.BID_MODIFIERS),
                        StringUtils.capitalize(BidModifierSetMap.ID)));
    }

    @Test
    public void noModifierValueInRequestTest() {
        api.userSteps.bidModifiersSteps().shouldGetJSONErrorOn(
                ServiceNames.BID_MODIFIERS,
                client,
                Action.SET,
                new JsonObject()
                        .with(StringUtils.capitalize(SetRequestMap.BID_MODIFIERS), new Object[]{new JsonObject()
                                .with(StringUtils.capitalize(BidModifierSetMap.ID), bmID)}),
                new Api5Error(8000, Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        StringUtils.capitalize(SetRequestMap.BID_MODIFIERS),
                        StringUtils.capitalize(BidModifierSetMap.BID_MODIFIER)));
    }
}
