package ru.yandex.autotests.direct.api.bidmodifiers.set;

import com.google.common.primitives.Shorts;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DesktopAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasProperty;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(BidModifiersFeatures.SET)
@Tag(TagDictionary.TRUNK)
@Description("Проверка состояния БД при изменении десктопных корректировок")
public class SetDesktopBidModifierAndCheckDbTest {
    private static final String CLIENT = BidModifiersLogins.SINGLE_CLIENT_SET;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static DirectJooqDbSteps jooqDbSteps;
    private static Long cpmCampaignId;

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);
        cpmCampaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);

    }

    @Test
    public void setNewValueToDesktopAdjustmentAndCheckRecordInHierarchicalMultipliersTable() {
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(cpmCampaignId);
        Long bidModifierId = api.userSteps.bidModifiersSteps().addBidModifierDesktopToGroup(adGroupId);

        api.userSteps.bidModifiersSteps().bidModifiersSet(
                bidModifierId, DesktopAdjustmentMap.DESKTOP_ADJUSTMENT_ABSOLUTE_MIN);

        assertThat("Запись в БД создана с правильным коэффициентом",
                jooqDbSteps.multipliersSteps().getHierarchicalMultipliersByPid(adGroupId),
                contains(hasProperty("multiplierPct",
                        equalTo(Shorts.checkedCast(DesktopAdjustmentMap.DESKTOP_ADJUSTMENT_ABSOLUTE_MIN))))
        );
    }
}
