package ru.yandex.autotests.direct.api.bidmodifiers.set;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.IncomeGradeAdjustmentGetMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.IncomeGradeAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.CompareStrategy;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Features(BidModifiersFeatures.SET)
@Description("Изменение установленных корректировок ставок на доход")
public class SetIncomeGradeBidModifiersTest {

    private static final String LOGIN = BidModifiersLogins.SINGLE_CLIENT_SET;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long groupId;
    private Long campaignId;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        campaignId = api.as(LOGIN).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        groupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
    }

    @Test
    public void addIncomeGradeBidModifierForCampaign() {
        List<Long> addedBidModifiers = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withCampaignId(campaignId)
                        .withIncomeGradeAdjustments(
                                new IncomeGradeAdjustmentMap()
                                        .withBidModifier(100)
                                        .withDefaultGrade()
                        )
        );
        int newBidModifierValue = 300;
        assumeThat("корректировка ставки установлена", addedBidModifiers, hasSize(1));
        Long bidModifierId = addedBidModifiers.get(0);
        api.userSteps.bidModifiersSteps().bidModifiersSet(bidModifierId, newBidModifierValue);

        List<BidModifierGetItem> result = api.userSteps.bidModifiersSteps().bidModifiersGetByCampaignId(campaignId);

        CompareStrategy strategy = DefaultCompareStrategies.onlyExpectedFields();
        assertThat("вернулась новая корректировка", result, beanDiffer(
                Arrays.asList(
                        (BidModifierGetItem) new BidModifierGetItemMap()
                                .withIncomeGradeAdjustment(
                                        new IncomeGradeAdjustmentGetMap()
                                                .withBidModifier(newBidModifierValue)
                                ).getBean()))
                .useCompareStrategy(strategy));
    }

    @Test
    public void addIncomeGradeBidModifierForGroup() {
        List<Long> addedBidModifiers = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withAdGroupId(groupId)
                        .withIncomeGradeAdjustments(
                                new IncomeGradeAdjustmentMap()
                                        .withBidModifier(100)
                                        .withDefaultGrade()
                        )
        );
        int newBidModifierValue = 300;
        assumeThat("корректировка ставки установлена", addedBidModifiers, hasSize(1));
        Long bidModifierId = addedBidModifiers.get(0);
        api.userSteps.bidModifiersSteps().bidModifiersSet(bidModifierId, newBidModifierValue);

        List<BidModifierGetItem> result = api.userSteps.bidModifiersSteps().bidModifiersGetByAdGroupId(groupId);

        CompareStrategy strategy = DefaultCompareStrategies.onlyExpectedFields();
        assertThat("вернулась новая корректировка", result, beanDiffer(
                Arrays.asList(
                        (BidModifierGetItem) new BidModifierGetItemMap()
                                .withIncomeGradeAdjustment(
                                        new IncomeGradeAdjustmentGetMap()
                                                .withBidModifier(newBidModifierValue)
                                ).getBean()))
                .useCompareStrategy(strategy));
    }

}
