package ru.yandex.autotests.direct.api.bidmodifiers.toggle;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierToggleMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.JavaOrPerlToggleExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 11.08.15.
 */
@Aqua.Test
@Features(BidModifiersFeatures.TOGGLE)
@Tag(TagDictionary.TRUNK)
@Description("Проверка доступа агентства к отключению наборов корректировок ставок у субклиентов")
public class ToggleBidModifiersAgencyAccessTest {
    private static final String singleClient = BidModifiersLogins.SINGLE_CLIENT_TOGGLE;

    private static final String agency = BidModifiersLogins.AGENCY_4;
    private static final String subclient1 = BidModifiersLogins.SUBCLIENT_1;
    private static final String subclient2 = BidModifiersLogins.SUBCLIENT_2;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
    }

    @Test
    @Description("Отключаем агентством набор корректировок созданный сублиентом")
    public void toggleBidModifierByAgencyTest() {
        Long campaignID = api.as(subclient1).userSteps.campaignSteps().addDefaultTextCampaign(subclient1);
        api.userSteps.bidModifiersSteps().addBidModifierDemographicsToCampaign(campaignID.intValue());
        api.as(agency).userSteps.bidModifiersSteps().shouldGetResultOn(
                subclient1,
                Action.TOGGLE,
                new ToggleRequestMap().withBidModifierToggleItems(new BidModifierToggleMap()
                        .defaultBidModifier()
                        .withCampaignId(campaignID)),
                ToggleExpectedResult.successCampaign(campaignID));
    }

    @Test
    @Description("Отключаем агентством набор корректировок субклиенту, указав кампанию другого субклиента")
    public void anotherSubсlientModifierTest() {
        Long campaignID = api.as(subclient2).userSteps.campaignSteps().addDefaultTextCampaign(subclient2);
        api.userSteps.bidModifiersSteps().addBidModifierDemographicsToCampaign(campaignID.intValue());
        api.as(agency).userSteps.bidModifiersSteps().shouldGetToggleResultOn(
                subclient1,
                new ToggleRequestMap().withBidModifierToggleItems(new BidModifierToggleMap()
                        .defaultBidModifier()
                        .withCampaignId(campaignID)),
                JavaOrPerlToggleExpectedResult.java(
                        ToggleExpectedResult
                                .errors(new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_NOT_FOUND, campaignID)))
                        .perl(
                                ToggleExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND))
                        ));
    }

    @Test
    @Description("Отключаем агентством набор корректировок субклиенту, указав свою кампанию и кампанию другого сублиента")
    public void ownedModifierAndAnotherSubсlientModifierTest() {
        Long campaignID1 = api.as(subclient1).userSteps.campaignSteps().addDefaultTextCampaign(subclient1);
        api.userSteps.bidModifiersSteps().addBidModifierDemographicsToCampaign(campaignID1.intValue());
        Long campaignID2 = api.as(subclient2).userSteps.campaignSteps().addDefaultTextCampaign(subclient2);
        api.userSteps.bidModifiersSteps().addBidModifierDemographicsToCampaign(campaignID2.intValue());
        api.as(agency).userSteps.bidModifiersSteps().shouldGetToggleResultOn(
                subclient1,
                new ToggleRequestMap().withBidModifierToggleItems(
                        new BidModifierToggleMap()
                                .defaultBidModifier()
                                .withCampaignId(campaignID1),
                        new BidModifierToggleMap()
                                .defaultBidModifier()
                                .withCampaignId(campaignID2)),
                JavaOrPerlToggleExpectedResult.both(ToggleExpectedResult.successCampaign(campaignID1)),
                JavaOrPerlToggleExpectedResult.java(
                        ToggleExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_NOT_FOUND,
                                campaignID2)))
                        .perl(
                                ToggleExpectedResult.errors(new Notification(8800,
                                        Api5ErrorDetails.CAMPAIGN_NOT_FOUND))
                        ));
    }

    @Test
    @Description("Отключаем агентством набор корректировок субклиенту, указав кампанию самостоятельного клиента")
    public void nonOwnedModifierByAgencyTest() {
        Long campaignID = api.as(singleClient).userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
        api.userSteps.bidModifiersSteps().addBidModifierMobileToCampaign(campaignID);
        api.as(agency).userSteps.bidModifiersSteps().shouldGetToggleResultOn(
                subclient1,
                new ToggleRequestMap().withBidModifierToggleItems(new BidModifierToggleMap()
                        .defaultBidModifier()
                        .withCampaignId(campaignID)),
                JavaOrPerlToggleExpectedResult.java(
                        ToggleExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_NOT_FOUND,
                                campaignID)))
                        .perl(
                                ToggleExpectedResult.errors(new Notification(8800,
                                        Api5ErrorDetails.CAMPAIGN_NOT_FOUND))));
    }
}
