package ru.yandex.autotests.direct.api.bidmodifiers.toggle;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierToggleTypeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.beans.JsonObject;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierToggleMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 11.08.15.
 */
@Aqua.Test
@Features(BidModifiersFeatures.TOGGLE)
@Stories(ApiStories.JSON5)
@RunWith(Parameterized.class)
@Description("Проверка валидации типов полей структуры BidModifierToggleItem")
public class ToggleBidModifiersFieldTypesNegativeTest {

    private static final String singleClient = BidModifiersLogins.SINGLE_CLIENT_TOGGLE;
    private static long groupID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient).protocol(ProtocolType.JSON);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String fieldName;

    @Parameterized.Parameter(value = 2)
    public Object fieldValue;

    @Parameterized.Parameter(value = 3)
    public Api5Error perlError;

    @Parameterized.Parameter(value = 4)
    public Api5Error javaError;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection fields() {
        Object[][] data = new Object[][]{
                {"Вещественное число в поле AdGroupId", BidModifierToggleMap.AD_GROUP_ID, 2.13f,
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                                StringUtils.capitalize(BidModifierToggleMap.AD_GROUP_ID)),
                        new Api5Error(8000,
                                Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD2,
                                "BidModifierToggleItems." + StringUtils.capitalize(BidModifierToggleMap.AD_GROUP_ID))
                },
                {"JSON объект в поле AdGroupId", BidModifierToggleMap.AD_GROUP_ID, new JSONObject(),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                                StringUtils.capitalize(BidModifierToggleMap.AD_GROUP_ID)),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                                "BidModifierToggleItems." + StringUtils.capitalize(BidModifierToggleMap.AD_GROUP_ID))
                },
                {"Массив в поле AdGroupId", BidModifierToggleMap.AD_GROUP_ID, Arrays.asList(123456),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                StringUtils.capitalize(BidModifierToggleMap.AD_GROUP_ID)),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                "BidModifierToggleItems." + StringUtils.capitalize(BidModifierToggleMap.AD_GROUP_ID))
                },
                {"Вещественное число в поле Type", BidModifierToggleMap.TYPE, 2.13f,
                        new Api5Error(8000,
                                Api5ErrorDetails.INCORRECT_ENUMERATE_VALUE,
                                StringUtils.capitalize(BidModifierToggleMap.TYPE)),
                        new Api5Error(8000,
                                Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD2,
                                "BidModifierToggleItems." + StringUtils.capitalize(BidModifierToggleMap.TYPE))
                },
                {"JSON объект в поле Type", BidModifierToggleMap.TYPE, new JSONObject(),
                        new Api5Error(8000,
                                Api5ErrorDetails.INCORRECT_ENUMERATE_VALUE,
                                StringUtils.capitalize(BidModifierToggleMap.TYPE)),
                        new Api5Error(8000,
                                Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD2,
                                "BidModifierToggleItems." + StringUtils.capitalize(BidModifierToggleMap.TYPE))
                },
                {"Массив в поле Type", BidModifierToggleMap.TYPE,
                        Arrays.asList(BidModifierToggleTypeEnum.DEMOGRAPHICS_ADJUSTMENT),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                StringUtils.capitalize(BidModifierToggleMap.TYPE)),
                        new Api5Error(8000,
                                Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                "BidModifierToggleItems." + StringUtils.capitalize(BidModifierToggleMap.TYPE))
                }
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.bidModifiersSteps().addBidModifierDemographicsToGroup(groupID);
    }

    @Test
    public void invalidRequiredFieldTypeTest() {
        JsonObject toggleRequest = new JsonObject()
                .with(StringUtils.capitalize(ToggleRequestMap.BID_MODIFIER_TOGGLE_ITEMS), Arrays.asList(
                        new JsonObject()
                                .with(StringUtils.capitalize(BidModifierToggleMap.AD_GROUP_ID), groupID)
                                .with(StringUtils.capitalize(BidModifierToggleMap.TYPE),
                                        BidModifierToggleTypeEnum.DEMOGRAPHICS_ADJUSTMENT)
                                .with(StringUtils.capitalize(BidModifierToggleMap.ENABLED), YesNoEnum.NO)
                                .with(StringUtils.capitalize(fieldName), fieldValue)
                ));

        api.userSteps.bidModifiersSteps().shouldGetJSONErrorOn(
                ServiceNames.BID_MODIFIERS,
                null,
                Action.TOGGLE,
                toggleRequest,
                JavaOrPerlApi5Error
                        .java(javaError)
                        .perl(perlError)
        );
    }
}
