package ru.yandex.autotests.direct.api.bidmodifiers.toggle;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierToggleMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.JavaOrPerlToggleExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 11.08.15
 */
@Aqua.Test
@Features(BidModifiersFeatures.TOGGLE)
@Tag(TagDictionary.TRUNK)
@Description("Запрос на отключение наборов корректировок с указанием невалидных идентификаторов")
@RunWith(Parameterized.class)
public class ToggleBidModifiersInvalidIdsTest {

    private static final String client = BidModifiersLogins.SINGLE_CLIENT_TOGGLE;
    private static final String anotherClient = BidModifiersLogins.SINGLE_CLIENT_ANOTHER;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final Long nonExistedCampaign = 12345L;
    private static Long groupDeleted;
    private static Long groupAnother;
    private static final Long nonExistedGroup = 123456L;

    @Parameterized.Parameter(0)
    public String fieldName;

    @Parameterized.Parameter(1)
    public String description;

    @Parameterized.Parameter(2)
    public String operator;

    @Parameterized.Parameter(3)
    public Long idValue;

    @Parameterized.Parameter(4)
    public ToggleExpectedResult perlResult;

    @Parameterized.Parameter(5)
    public ToggleExpectedResult javaResult;

    @Parameterized.Parameters(name = "field = {0}, test = {1}")
    public static Collection<Object[]> data() {
        prepareBidModifiers();
        return Arrays.asList(new Object[][]{
                {BidModifierToggleMap.AD_GROUP_ID, "Нулевой ID", client, 0L,
                        ToggleExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                        StringUtils.capitalize(BidModifierToggleMap.AD_GROUP_ID))),
                        ToggleExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER_BM,
                                        BidModifierToggleMap.AD_GROUP_ID))},
                {BidModifierToggleMap.AD_GROUP_ID, "Отрицательный ID", client, -1L,
                        ToggleExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                        StringUtils.capitalize(BidModifierToggleMap.AD_GROUP_ID))),
                        ToggleExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER_BM,
                                        BidModifierToggleMap.AD_GROUP_ID))},
                {BidModifierToggleMap.AD_GROUP_ID, "Несуществующий ID", client, nonExistedGroup,
                        ToggleExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)),
                        ToggleExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.GROUP_NOT_FOUND,
                                nonExistedGroup))},
                {BidModifierToggleMap.AD_GROUP_ID, "Удаленный ID", client, groupDeleted,
                        ToggleExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)),
                        ToggleExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.GROUP_NOT_FOUND,
                                groupDeleted))},
                {BidModifierToggleMap.AD_GROUP_ID, "Чужой ID", client, groupAnother,
                        ToggleExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)),
                        ToggleExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.GROUP_NOT_FOUND,
                                groupAnother))},
                {BidModifierToggleMap.CAMPAIGN_ID, "Нулевой ID", client, 0L,
                        ToggleExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                        StringUtils.capitalize(BidModifierToggleMap.CAMPAIGN_ID))),
                        ToggleExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER_BM,
                                        BidModifierToggleMap.CAMPAIGN_ID))},
                {BidModifierToggleMap.CAMPAIGN_ID, "Отрицательный ID", client, -1L,
                        ToggleExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                        StringUtils.capitalize(BidModifierToggleMap.CAMPAIGN_ID))),
                        ToggleExpectedResult.errors(
                                new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER_BM,
                                        BidModifierToggleMap.CAMPAIGN_ID))},
                {BidModifierToggleMap.CAMPAIGN_ID, "Несуществующий ID", client, nonExistedCampaign,
                        ToggleExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)),
                        ToggleExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_NOT_FOUND,
                                nonExistedCampaign))},
                {BidModifierToggleMap.CAMPAIGN_ID, "Удаленный ID", client, groupDeleted,
                        ToggleExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)),
                        ToggleExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_NOT_FOUND,
                                groupDeleted))},
                {BidModifierToggleMap.CAMPAIGN_ID, "Чужой ID", client, groupAnother,
                        ToggleExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)),
                        ToggleExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_NOT_FOUND,
                                groupAnother))},
        });
    }

    private static void prepareBidModifiers() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(anotherClient);

        api.as(anotherClient);
        Long anotherCampaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(anotherClient);
        groupAnother = api.userSteps.adGroupsSteps().addDefaultGroup(anotherCampaignID);

        api.as(client);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupDeleted = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adGroupsSteps().deleteGroup(groupDeleted);
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void invalidIdsTest() {
        BidModifierToggleMap toggleMap = new BidModifierToggleMap().defaultBidModifier();
        ReflectionUtils.setBeanMapFieldValue(toggleMap, "with" + StringUtils.capitalize(fieldName), idValue);

        api.as(operator).userSteps.bidModifiersSteps().shouldGetToggleResultOn(
                null,
                new ToggleRequestMap().withBidModifierToggleItems(toggleMap),
                JavaOrPerlToggleExpectedResult.java(javaResult)
                        .perl(perlResult));
    }
}
