package ru.yandex.autotests.direct.api.bidmodifiers.toggle;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierToggleTypeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierToggleMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by buhter on 14.08.17
 */
@Aqua.Test
@Features(BidModifiersFeatures.TOGGLE)
@Description("Проверка сценариев отключения наборов корректировок для групп/кампаний неподдерживаемых типов")
@RunWith(Parameterized.class)
public class ToggleBidModifiersMcbannerTest {
    private static int shard;
    private static final String LOGIN = BidModifiersLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adGroupId;
    private Long campaignId;

    @Parameterized.Parameter()
    public CampaignsType campaignsType;

    @Parameterized.Parameter(1)
    public PhrasesAdgroupType adgroupType;

    @Parameterized.Parameters(name = "типа кампании:{0}, тип группы:{1}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignsType.MCBANNER, PhrasesAdgroupType.mcbanner},
        });
    }

    @BeforeClass
    public static void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void createTestData() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);

        api.userSteps.campaignFakeSteps().setType(campaignId, campaignsType);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                .setType(adGroupId, adgroupType);
    }


    @Test
    public void toggleWithNotSupportedCampaignId() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.TOGGLE,
                new ToggleRequestMap().withBidModifierToggleItems(new BidModifierToggleMap()
                        .withCampaignId(campaignId)
                        .withType(BidModifierToggleTypeEnum.DEMOGRAPHICS_ADJUSTMENT)
                        .withEnabled(YesNoEnum.NO)),
                ToggleExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND_BY_ID, campaignId)));
    }

    @Test
    public void toggleWithNotSupportedAdGroupId() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.TOGGLE,
                new ToggleRequestMap().withBidModifierToggleItems(new BidModifierToggleMap()
                        .withAdGroupId(adGroupId)
                        .withType(BidModifierToggleTypeEnum.DEMOGRAPHICS_ADJUSTMENT)
                        .withEnabled(YesNoEnum.NO)),
                ToggleExpectedResult.errors(new Notification(8800, Api5ErrorDetails.ADGROUP_NOT_FOUND_BY_ID, adGroupId)));
    }
}
