package ru.yandex.autotests.direct.api.bidmodifiers.toggle;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierToggleTypeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierToggleMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.JavaOrPerlToggleExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 31.07.15
 */
@Aqua.Test
@Features(BidModifiersFeatures.TOGGLE)
@Tag(TagDictionary.TRUNK)
@Description("Проверка негативных сценариев отключения набора корректировок ставок")
public class ToggleBidModifiersNegativeTest {
    private static final String CLIENT = BidModifiersLogins.SINGLE_CLIENT_TOGGLE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private Long adGroupId;
    private Long campaignId;

    @Rule
    public Trashman trasher = new Trashman(api);


    @Before
    @Step("Подготовим данные для теста")
    public void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.bidModifiersSteps().addBidModifierDemographicsToCampaign(campaignId.intValue());
    }

    @Test
    @Description("Попробуем отключить набор корректировок для архивной кампании")
    public void archivedCampaignTest() {
        api.userSteps.campaignSteps().campaignsSuspend(campaignId);
        api.userSteps.campaignSteps().campaignsArchive(campaignId);

        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.TOGGLE,
                new ToggleRequestMap().withBidModifierToggleItems(new BidModifierToggleMap()
                        .withCampaignId(campaignId)
                        .withEnabled(YesNoEnum.NO)
                        .withType(BidModifierToggleTypeEnum.RETARGETING_ADJUSTMENT)),
                ToggleExpectedResult.errors(new Notification(8300, Api5ErrorDetails.UNABLE_UPDATE_ARCHIVED_CAMPAGN)));
    }

    @Test
    @Description("Попробуем отключить набор корректировок на регион для группы")
    public void regionalAdjustmentWithGroupTest() {
        api.userSteps.bidModifiersSteps().shouldGetToggleResultOn(
                null,
                new ToggleRequestMap().withBidModifierToggleItems(new BidModifierToggleMap()
                        .withAdGroupId(adGroupId)
                        .withEnabled(YesNoEnum.NO)
                        .withType(BidModifierToggleTypeEnum.REGIONAL_ADJUSTMENT)),
                JavaOrPerlToggleExpectedResult.java(ToggleExpectedResult.errors(new Notification(3500,
                        Api5ErrorDetailsJava.REGIONAL_ADJUSTMENT_NOT_SUPPORTED_IN_ADGROUP)))
                        .perl(ToggleExpectedResult.errors(new Notification(3500,
                                Api5ErrorDetails.REGIONAL_ADJUSTMENT_NOT_SUPPORTED_IN_ADGROUP))));

    }
}
