package ru.yandex.autotests.direct.api.bidmodifiers.toggle;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierToggleTypeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierToggleMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 11.08.15
 */
@Aqua.Test
@Features(BidModifiersFeatures.TOGGLE)
@Description("Проверка сценариев отключения наборов корректировок для групп/кампаний, в которых отсутствуют наборы " +
        "корректировок")
@RunWith(Parameterized.class)
public class ToggleBidModifiersNoBidModifierTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_TOGGLE;

    private static Long campaignID;
    private static Long groupID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public BidModifierToggleMap toggleMap;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection testData() {
        prepareGroup();
        Object[][] data = new Object[][]{
                {"Демографический для группы",
                        new BidModifierToggleMap()
                                .withAdGroupId(groupID)
                                .withType(BidModifierToggleTypeEnum.DEMOGRAPHICS_ADJUSTMENT)},
                {"Ретаргетинговый для группы",
                        new BidModifierToggleMap()
                                .withAdGroupId(groupID)
                                .withType(BidModifierToggleTypeEnum.RETARGETING_ADJUSTMENT)},
                {"Демографический для кампании",
                        new BidModifierToggleMap()
                                .withCampaignId(campaignID)
                                .withType(BidModifierToggleTypeEnum.DEMOGRAPHICS_ADJUSTMENT)},
                {"Ретаргетинговый для кампании",
                        new BidModifierToggleMap()
                                .withCampaignId(campaignID)
                                .withType(BidModifierToggleTypeEnum.RETARGETING_ADJUSTMENT)},
                {"Региональный для кампании",
                        new BidModifierToggleMap()
                                .withCampaignId(campaignID)
                                .withType(BidModifierToggleTypeEnum.REGIONAL_ADJUSTMENT)},
                {"На позицию для кампании",
                        new BidModifierToggleMap()
                                .withCampaignId(campaignID)
                                .withType(BidModifierToggleTypeEnum.SERP_LAYOUT_ADJUSTMENT)}
        };
        return Arrays.asList(data);
    }

    private static void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void bidModifiersTypeTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.TOGGLE,
                new ToggleRequestMap().withBidModifierToggleItems(
                        toggleMap.withEnabled(YesNoEnum.NO)),
                ToggleExpectedResult.errors(new Notification(8800, Api5ErrorDetails.BID_MODIFIER_SET_NOT_FOUND)));
    }

    @AfterClass
    public static void putCampaignToRemove() {
        //workaround для корректроного создания кампаний в параметризованном тесте
        api.userSteps.campaignSteps().putCampaignToQueue(client, campaignID);
    }
}
