package ru.yandex.autotests.direct.api.bidmodifiers.toggle;

import java.util.List;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierToggleTypeEnum;
import com.yandex.direct.api.v5.general.AgeRangeEnum;
import com.yandex.direct.api.v5.general.SerpLayoutEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierToggleMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DemographicsAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RegionalAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SerpLayoutAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.everyItem;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 11.08.15.
 */
@Aqua.Test
@Features(BidModifiersFeatures.TOGGLE)
@Tag(TagDictionary.TRUNK)
@Description("Проверка позитивных сценариев активации множественных наборов корректировок")
public class ToggleBidModifiersPositiveMultipleTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_TOGGLE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignID;
    private static Integer regionId1 = RegionIDValues.SPB.getId();
    private static Integer regionId2 = RegionIDValues.MOSCOW.getId();
    private static Integer regionId3 = RegionIDValues.BELARUS.getId();

    @Before
    @Step("Подготовка данных для теста")
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Test
    @Description("Отключение демографического набора кампании с несколькими корректировками - отключились все корректировки набора")
    public void toggleBidModifiersDemographicMultipleTest() {
        log.info("Подготовим демографические корректировки ставок");
        List<Long> bmIDs = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withDemographicsAdjustment(
                                new DemographicsAdjustmentMap()
                                        .withAge(AgeRangeEnum.AGE_18_24)
                                        .withDefaultBidModifier(),
                                new DemographicsAdjustmentMap()
                                        .withAge(AgeRangeEnum.AGE_25_34)
                                        .withDefaultBidModifier())
                        .withCampaignId(campaignID));
        assumeThat("созданы корректировки ставок", bmIDs, hasSize(2));

        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.TOGGLE,
                new ToggleRequestMap().withBidModifierToggleItems(
                        new BidModifierToggleMap()
                                .withCampaignId(campaignID)
                                .withType(BidModifierToggleTypeEnum.DEMOGRAPHICS_ADJUSTMENT)
                                .withEnabled(YesNoEnum.NO)
                ),
                ToggleExpectedResult.successCampaign(campaignID));
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(bmIDs.get(0), bmIDs.get(1));
        List<YesNoEnum> enabled = extract(bms, on(BidModifierGetItem.class).getDemographicsAdjustment().getEnabled());
        assertThat("значение поля Enabled корректировок демографического набора", enabled, everyItem(equalTo(YesNoEnum.NO)));
    }

    @Test
    @Description("Отключение демографических набора кампании, которая также имеет ретаргетинговую корректировку")
    public void toggleBidModifiersTypeTest() {
        log.info("Подготовим демографическую и ретаргетинговую корректировки ставок");
        Integer conditionID = api.userSteps.retargetingSteps().addRandomRetargetingCondition(client);
        List<Long> bmIDs = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withDemographicsAdjustment(
                                new DemographicsAdjustmentMap()
                                        .withAge(AgeRangeEnum.AGE_18_24)
                                        .withDefaultBidModifier())
                        .withCampaignId(campaignID),
                new BidModifierAddMap()
                        .withRetargetingAdjustment(
                                new RetargetingAdjustmentMap()
                                        .withRetargetingConditionId(conditionID.longValue())
                                        .withDefaultBidModifier())
                        .withCampaignId(campaignID));
        assumeThat("созданы корректировки ставок", bmIDs, hasSize(2));

        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.TOGGLE,
                new ToggleRequestMap().withBidModifierToggleItems(
                        new BidModifierToggleMap()
                                .withCampaignId(campaignID)
                                .withType(BidModifierToggleTypeEnum.DEMOGRAPHICS_ADJUSTMENT)
                                .withEnabled(YesNoEnum.NO)
                ),
                ToggleExpectedResult.successCampaign(campaignID));
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(bmIDs.get(0));
        assumeThat("получили корректировку ставок", bms, hasSize(1));
        assumeThat("получили демографический набор корретировок", bms.get(0).getDemographicsAdjustment(), notNullValue());
        assertThat("значение поля Enabled корректировок демографического набора", bms.get(0).getDemographicsAdjustment().getEnabled(), (equalTo(YesNoEnum.NO)));

        bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(bmIDs.get(1));
        assumeThat("получили корректировку ставок", bms, hasSize(1));
        assumeThat("получили набор корретировок ретаргетинга", bms.get(0).getRetargetingAdjustment(), notNullValue());
        assertThat("значение поля Enabled корректировок ретаргетинга", bms.get(0).getRetargetingAdjustment().getEnabled(), (equalTo(YesNoEnum.YES)));
    }

    @Test
    @Description("Отключение демографических набора кампании, которая также имеет группу с демографической корректировкой")
    public void toggleBidModifiersLevelsTest() {
        log.info("Подготовим различные корректировки ставок");
        Long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        List<Long> bmIDs = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withDemographicsAdjustment(
                                new DemographicsAdjustmentMap().defaultDemographicsAdjustment())
                        .withCampaignId(campaignID),
                new BidModifierAddMap()
                        .withDemographicsAdjustment(
                                new DemographicsAdjustmentMap().defaultDemographicsAdjustment())
                        .withAdGroupId(groupID)
        );
        assumeThat("созданы корректировки ставок", bmIDs, hasSize(2));

        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.TOGGLE,
                new ToggleRequestMap().withBidModifierToggleItems(
                        new BidModifierToggleMap()
                                .withCampaignId(campaignID)
                                .withType(BidModifierToggleTypeEnum.DEMOGRAPHICS_ADJUSTMENT)
                                .withEnabled(YesNoEnum.NO)
                ),
                ToggleExpectedResult.successCampaign(campaignID));
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(bmIDs.get(0));
        assumeThat("получили корректировку ставок", bms, hasSize(1));
        assumeThat("получили демографический набор корретировок", bms.get(0).getDemographicsAdjustment(), notNullValue());
        assertThat("значение поля Enabled корректировок кампании", bms.get(0).getDemographicsAdjustment().getEnabled(), (equalTo(YesNoEnum.NO)));

        bms.clear();
        bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(bmIDs.get(1));
        assumeThat("получили корректировку ставок", bms, hasSize(1));
        assumeThat("получили демографический набор корретировок", bms.get(0).getDemographicsAdjustment(), notNullValue());
        assertThat("значение поля Enabled корректировок группы", bms.get(0).getDemographicsAdjustment().getEnabled(), (equalTo(YesNoEnum.YES)));
    }

    @Test
    @Description("Отключение регионального набора кампании с несколькими корректировками - отключились все корректировки набора")
    public void toggleBidModifiersRegionalMultipleTest() {
        log.info("Подготовим региональные корректировки ставок");
        List<Long> bmIDs = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withRegionalAdjustment(
                                new RegionalAdjustmentMap()
                                        .withRegionId(regionId1)
                                        .withDefaultBidModifier(),
                                new RegionalAdjustmentMap()
                                        .withRegionId(regionId2)
                                        .withDefaultBidModifier())
                        .withCampaignId(campaignID));
        assumeThat("созданы корректировки ставок", bmIDs, hasSize(2));

        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.TOGGLE,
                new ToggleRequestMap().withBidModifierToggleItems(
                        new BidModifierToggleMap()
                                .withCampaignId(campaignID)
                                .withType(BidModifierToggleTypeEnum.REGIONAL_ADJUSTMENT)
                                .withEnabled(YesNoEnum.NO)
                ),
                ToggleExpectedResult.successCampaign(campaignID));
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(bmIDs.get(0), bmIDs.get(1));
        List<YesNoEnum> enabled = extract(bms, on(BidModifierGetItem.class).getRegionalAdjustment().getEnabled());
        assertThat("значение поля Enabled корректировок регионального набора", enabled, everyItem(equalTo(YesNoEnum.NO)));
    }

    @Test
    @Description("Отключение регионального набора кампании, которая также имеет ретаргетинговую корректировку")
    public void toggleBidModifiersRegionalTypeTest() {
        log.info("Подготовим региональную и ретаргетинговую корректировки ставок");
        Integer conditionID = api.userSteps.retargetingSteps().addRandomRetargetingCondition(client);
        List<Long> bmIDs = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withRegionalAdjustment(
                                new RegionalAdjustmentMap()
                                        .withRegionId(regionId3)
                                        .withDefaultBidModifier())
                        .withCampaignId(campaignID),
                new BidModifierAddMap()
                        .withRetargetingAdjustment(
                                new RetargetingAdjustmentMap()
                                        .withRetargetingConditionId(conditionID.longValue())
                                        .withDefaultBidModifier())
                        .withCampaignId(campaignID));
        assumeThat("созданы корректировки ставок", bmIDs, hasSize(2));

        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.TOGGLE,
                new ToggleRequestMap().withBidModifierToggleItems(
                        new BidModifierToggleMap()
                                .withCampaignId(campaignID)
                                .withType(BidModifierToggleTypeEnum.REGIONAL_ADJUSTMENT)
                                .withEnabled(YesNoEnum.NO)
                ),
                ToggleExpectedResult.successCampaign(campaignID));
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(bmIDs.get(0));
        assumeThat("получили корректировку ставок", bms, hasSize(1));
        assumeThat("получили региональный набор корретировок", bms.get(0).getRegionalAdjustment(), notNullValue());
        assertThat("значение поля Enabled корректировок регионального набора",
                bms.get(0).getRegionalAdjustment().getEnabled(), (equalTo(YesNoEnum.NO)));

        bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(bmIDs.get(1));
        assumeThat("получили корректировку ставок", bms, hasSize(1));
        assumeThat("получили набор корретировок ретаргетинга", bms.get(0).getRetargetingAdjustment(), notNullValue());
        assertThat("значение поля Enabled корректировок ретаргетинга",
                bms.get(0).getRetargetingAdjustment().getEnabled(), (equalTo(YesNoEnum.YES)));
    }

    @Test
    @Description("Отключение набора кампании с несколькими корректировками на позицию - отключились все корректировки" +
            " набора")
    public void toggleBidModifiersSerpLayoutMultipleTest() {
        log.info("Подготовим корректировки ставок на позицию");
        List<Long> bmIDs = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withSerpLayoutAdjustment(
                                new SerpLayoutAdjustmentMap()
                                        .withSerpLayout(SerpLayoutEnum.ALONE)
                                        .withDefaultBidModifier(),
                                new SerpLayoutAdjustmentMap()
                                        .withSerpLayout(SerpLayoutEnum.SUGGEST)
                                        .withDefaultBidModifier())
                        .withCampaignId(campaignID));
        assumeThat("созданы корректировки ставок", bmIDs, hasSize(2));

        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.TOGGLE,
                new ToggleRequestMap().withBidModifierToggleItems(
                        new BidModifierToggleMap()
                                .withCampaignId(campaignID)
                                .withType(BidModifierToggleTypeEnum.SERP_LAYOUT_ADJUSTMENT)
                                .withEnabled(YesNoEnum.NO)
                ),
                ToggleExpectedResult.successCampaign(campaignID));
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(bmIDs.get(0),
                bmIDs.get(1));
        List<YesNoEnum> enabled = extract(bms, on(BidModifierGetItem.class).getSerpLayoutAdjustment().getEnabled());
        assertThat("значение поля Enabled корректировок на позицию", enabled, everyItem(equalTo(YesNoEnum.NO)));
    }
}
