package ru.yandex.autotests.direct.api.bidmodifiers.toggle;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierToggleTypeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierToggleMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DemographicsAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RegionalAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SerpLayoutAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 31.07.15
 */
@Aqua.Test
@Features(BidModifiersFeatures.TOGGLE)
@Tag(TagDictionary.TRUNK)
@Description("Проверка позитивных сценариев отключения наборов корректировок")
@RunWith(Parameterized.class)
public class ToggleBidModifiersPositiveTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_TOGGLE;

    private static Long campaignID;
    private static Long groupID;
    private static Long bmID;
    private static Integer conditionID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public BidModifierAddMap addMap;

    @Parameterized.Parameter(value = 2)
    public BidModifierToggleMap toggleMap;

    @Parameterized.Parameter(value = 3)
    public String getterName;

    @Parameterized.Parameter(value = 4)
    public ToggleExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection testData() {
        prepareGroup();
        Object[][] data = new Object[][]{
                {"Демографический набор группы",
                        new BidModifierAddMap()
                                .withAdGroupId(groupID)
                                .withDemographicsAdjustment(new DemographicsAdjustmentMap()
                                .defaultDemographicsAdjustment()),
                        new BidModifierToggleMap()
                                .withAdGroupId(groupID)
                                .withType(BidModifierToggleTypeEnum.DEMOGRAPHICS_ADJUSTMENT),
                        "DemographicsAdjustment",
                        ToggleExpectedResult.successGroup(groupID, BidModifierToggleTypeEnum.DEMOGRAPHICS_ADJUSTMENT)},
                {"Ретаргетинговый набор группы",
                        new BidModifierAddMap()
                                .withAdGroupId(groupID)
                                .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .defaultRetargetingAdjustment()
                                .withRetargetingConditionId(conditionID)),
                        new BidModifierToggleMap()
                                .withAdGroupId(groupID)
                                .withType(BidModifierToggleTypeEnum.RETARGETING_ADJUSTMENT),
                        "RetargetingAdjustment",
                        ToggleExpectedResult.successGroup(groupID, BidModifierToggleTypeEnum.RETARGETING_ADJUSTMENT)},
                {"Демографический набор кампании",
                        new BidModifierAddMap()
                                .withCampaignId(campaignID)
                                .withDemographicsAdjustment(new DemographicsAdjustmentMap()
                                .defaultDemographicsAdjustment()),
                        new BidModifierToggleMap()
                                .withCampaignId(campaignID)
                                .withType(BidModifierToggleTypeEnum.DEMOGRAPHICS_ADJUSTMENT),
                        "DemographicsAdjustment",
                        ToggleExpectedResult.successCampaign(campaignID,
                                BidModifierToggleTypeEnum.DEMOGRAPHICS_ADJUSTMENT)},
                {"Ретаргетинговый набор кампании",
                        new BidModifierAddMap()
                                .withCampaignId(campaignID)
                                .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .defaultRetargetingAdjustment()
                                .withRetargetingConditionId(conditionID)),
                        new BidModifierToggleMap()
                                .withCampaignId(campaignID)
                                .withType(BidModifierToggleTypeEnum.RETARGETING_ADJUSTMENT),
                        "RetargetingAdjustment",
                        ToggleExpectedResult.successCampaign(campaignID,
                                BidModifierToggleTypeEnum.RETARGETING_ADJUSTMENT)},
                {"Региональный набор кампании",
                        new BidModifierAddMap()
                                .withCampaignId(campaignID)
                                .withRegionalAdjustment(new RegionalAdjustmentMap()
                                .defaultRegionalAdjustment()),
                        new BidModifierToggleMap()
                                .withCampaignId(campaignID)
                                .withType(BidModifierToggleTypeEnum.REGIONAL_ADJUSTMENT),
                        "RegionalAdjustment",
                        ToggleExpectedResult.successCampaign(campaignID,
                                BidModifierToggleTypeEnum.REGIONAL_ADJUSTMENT)},
                {"Набор корректировок на позицию на кампании",
                        new BidModifierAddMap()
                                .withCampaignId(campaignID)
                                .withSerpLayoutAdjustment(new SerpLayoutAdjustmentMap()
                                .defaultSerpLayoutAdjustment()),
                        new BidModifierToggleMap()
                                .withCampaignId(campaignID)
                                .withType(BidModifierToggleTypeEnum.SERP_LAYOUT_ADJUSTMENT),
                        "SerpLayoutAdjustment",
                        ToggleExpectedResult.successCampaign(campaignID,
                                BidModifierToggleTypeEnum.SERP_LAYOUT_ADJUSTMENT)},
        };
        return Arrays.asList(data);
    }

    private static void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        conditionID = api.userSteps.retargetingSteps().addRandomRetargetingCondition(client);
    }

    @Before
    public void prepareBidModifier() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        List<Long> bms = api.userSteps.bidModifiersSteps().bidModifiersAdd(addMap);
        assumeThat("создали корректировку ставок", bms, hasSize(1));
        bmID = bms.get(0);
    }

    @Test
    public void bidModifiersTypeTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.TOGGLE,
                new ToggleRequestMap().withBidModifierToggleItems(
                        toggleMap.withEnabled(YesNoEnum.NO)),
                expectedResult);

        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(bmID);
        assumeThat("получили корректировку ставок", bms, hasSize(1));
        Object adjustment = ReflectionUtils.invokeGetter(bms.get(0), getterName);
        assumeThat("получили набор корректировок", adjustment, notNullValue());
        assumeThat("флаг активации набора корректировок изменен",
                (YesNoEnum) ReflectionUtils.invokeGetter(adjustment, "Enabled"),
                equalTo(YesNoEnum.NO));

        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.TOGGLE,
                new ToggleRequestMap().withBidModifierToggleItems(
                        toggleMap.withEnabled(YesNoEnum.YES)),
                expectedResult);

        bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(bmID);
        adjustment = ReflectionUtils.invokeGetter(bms.get(0), getterName);
        assertThat("флаг активации набора корректировок изменен",
                (YesNoEnum) ReflectionUtils.invokeGetter(adjustment, "Enabled"),
                equalTo(YesNoEnum.YES));
    }

    @AfterClass
    public static void putCampaignToRemove() {
        //workaround для корректроного создания кампаний в параметризованном тесте
        api.userSteps.campaignSteps().putCampaignToQueue(client, campaignID);
    }
}
