package ru.yandex.autotests.direct.api.bidmodifiers.toggle;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierToggleMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.JavaOrPerlToggleExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.utils.AccessRightsErrorHelper.checkCatchingJavaAccessError;

/**
 * Created by chicos on 10.08.15
 * Параметризованный тест не подходит, так как в одной из ошибок нужно указывать группу
 */
@Aqua.Test
@Features(BidModifiersFeatures.TOGGLE)
@Description("Отключение наборов корректировок ставок от имени внутренних ролей - негативные тесты")
public class ToggleBidModifiersRolesAccessNegativeTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long groupID;

    @Test
    public void toggleBidModifierRolesTestSubclient() {
        String creator = BidModifiersLogins.AGENCY_1;
        String toggler = BidModifiersLogins.SUBCLIENT;
        String client = BidModifiersLogins.SUBCLIENT;

        log.info("Создадим кампанию, группу и корректировку ставок от имени " + creator);
        api.as(creator);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, client);
        api.userSteps.bidModifiersSteps().addBidModifierDemographicsToGroup(client, groupID);

        checkCatchingJavaAccessError(new Api5Error(54), () ->
                api.as(toggler).userSteps.bidModifiersSteps().shouldGetResultOn(
                        client,
                        Action.TOGGLE,
                        new ToggleRequestMap().withBidModifierToggleItems(
                                new BidModifierToggleMap()
                                        .defaultBidModifier()
                                        .withAdGroupId(groupID)),
                        ToggleExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE))));
    }
}
