package ru.yandex.autotests.direct.api.bidmodifiers.toggle;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonError;
import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonErrorMatcher;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierToggleMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Глобально негативные сценарии: падает весь вызов целиком, результат возвращается не привязанный к отдельным
 * элементам, а один на весь запрос.
 */
@Aqua.Test
@Features(BidModifiersFeatures.TOGGLE)
@Description("Отключение корректировок ставок от имени внутренних ролей - глобально негативные тесты")
@RunWith(Parameterized.class)
public class ToggleBidModifiersRolesGlobalAccessTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String creator;

    @Parameterized.Parameter(1)
    public String toggler;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public ToggleExpectedResult perlResult;

    @Parameterized.Parameter(4)
    public Api5Error javaResult;

    @Parameterized.Parameters(name = "creator = {0}, toggler = {1}, client = {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Logins.SUPER_LOGIN, Logins.MEDIA, BidModifiersLogins.SINGLE_CLIENT_TOGGLE,
                        ToggleExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)},
                {Logins.SUPER_LOGIN, Logins.SUPER_READER, BidModifiersLogins.SINGLE_CLIENT_TOGGLE,
                        ToggleExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)},
        });
    }

    private Long groupID;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareBidModifier() {
        log.info("Сбросим использованные юниты");
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(toggler);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(creator);

        log.info("Создадим кампанию, группу и корректировку ставок от имени " + creator);
        api.as(creator);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, client);
        api.userSteps.bidModifiersSteps().addBidModifierDemographicsToGroup(client, groupID);
    }

    @Test
    public void toggleBidModifierRolesTest() {
        Api5JsonError actualError = null;
        try {
            api.as(toggler).userSteps.bidModifiersSteps().shouldGetResultOn(
                    client,
                    Action.TOGGLE,
                    new ToggleRequestMap().withBidModifierToggleItems(
                            new BidModifierToggleMap()
                                    .defaultBidModifier()
                                    .withAdGroupId(groupID)),
                    perlResult);
        } catch (Api5JsonError error) {
            actualError = error;
        }

        if (actualError != null) {
            assertThat("Получена правильная ошибка", actualError,
                    new Api5JsonErrorMatcher(javaResult.toJsonError()));
        }
    }
}
