package ru.yandex.autotests.direct.api.bidmodifiers.toggle;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierToggleTypeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierToggleMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 11.08.15
 */
@Aqua.Test
@Features(BidModifiersFeatures.TOGGLE)
@Tag(TagDictionary.TRUNK)
@Description("Переключение активности набора корректировок ставок в ранее установленное значение")
@RunWith(Parameterized.class)
public class ToggleBidModifiersSameSwitchTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_TOGGLE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long groupID;
    private static Long bmID;
    private static Long campaignID;

    @Parameterized.Parameter(value = 0)
    public YesNoEnum enabled;

    @Parameterized.Parameters(name = "from {0} to {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {YesNoEnum.YES},
                {YesNoEnum.NO}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        bmID = api.userSteps.bidModifiersSteps().addBidModifierDemographicsToGroup(groupID);
        List<BidModifierGetItem> bms = api.userSteps.bidModifiersSteps().bidModifiersGetById(bmID);
        assumeThat("создана демографическая корректировка ставок", bms, hasSize(1));
        assumeThat("активности набора корректировок по умолчанию",
                bms.get(0).getDemographicsAdjustment().getEnabled(),
                equalTo(YesNoEnum.YES));
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @Description("Переключение активности набора корректировок в ранее установленное значение")
    public void sameSwitchTest() {
        if(enabled.equals(YesNoEnum.NO)){
            api.userSteps.bidModifiersSteps().toggleBidModifiersGroup(groupID, BidModifierToggleTypeEnum.DEMOGRAPHICS_ADJUSTMENT, YesNoEnum.NO);
        }
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.TOGGLE,
                new ToggleRequestMap()
                        .withBidModifierToggleItems(new BidModifierToggleMap()
                                .withAdGroupId(groupID)
                                .withEnabled(enabled)
                                .withType(BidModifierToggleTypeEnum.DEMOGRAPHICS_ADJUSTMENT)),
                ToggleExpectedResult.successGroup(groupID));
    }
}
