package ru.yandex.autotests.direct.api.bidmodifiers.toggle;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierToggleMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 11.08.15.
 */
@Aqua.Test
@Features(BidModifiersFeatures.TOGGLE)
@Description("Запросы на отключение наборов корректировок по протоколу SOAP")
public class ToggleBidModifiersSoapTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_TOGGLE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client).protocol(ProtocolType.SOAP);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    private static Long groupID;
    private static Long campaignID;

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.bidModifiersSteps().addBidModifierDemographicsToGroup(groupID);
    }

    @Test
    public void noBidModifierToogleItemsInRequestTest() {
        api.userSteps.bidModifiersSteps().shouldGetBidModifierErrorOn(
                Action.TOGGLE,
                new ToggleRequestMap(),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        StringUtils.capitalize(ToggleRequestMap.BID_MODIFIER_TOGGLE_ITEMS)));
    }

    @Test
    @Description("Попытка отключения набора корректировок без указания типа")
    public void noTypeFieldTest() {
        api.userSteps.bidModifiersSteps().shouldGetBidModifierErrorOn(
                Action.TOGGLE,
                new ToggleRequestMap().withBidModifierToggleItems(
                        new BidModifierToggleMap()
                                .withEnabled(YesNoEnum.NO)
                                .withAdGroupId(groupID)),
                new Api5Error(8000,
                        Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        StringUtils.capitalize(ToggleRequestMap.BID_MODIFIER_TOGGLE_ITEMS),
                        StringUtils.capitalize(BidModifierToggleMap.TYPE)));
    }

    @Test
    @Description("Валидный запрос на модификацию корректировки ставки")
    public void setBidModifierPositiveTest() {
        api.protocol(ProtocolType.JSON);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.bidModifiersSteps().addBidModifierDemographicsToGroup(groupID);

        api.protocol(ProtocolType.SOAP);
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.TOGGLE,
                new ToggleRequestMap().withBidModifierToggleItems(new BidModifierToggleMap()
                        .defaultBidModifier()
                        .withAdGroupId(groupID)),
                ToggleExpectedResult.successGroup(groupID));
    }
}
