package ru.yandex.autotests.direct.api.bidmodifiers.toggle;

import java.util.Arrays;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierToggleTypeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.beans.JsonObject;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierToggleMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.ToggleRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 11.08.15
 */
@Aqua.Test
@Description("Валидация JSON-запроса при отключении наборов корректировок ставок")
@Stories(ApiStories.JSON5)
@Features(BidModifiersFeatures.TOGGLE)
public class ToggleBidModifiersStructureNegativeJsonTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_TOGGLE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long groupID;
    private static Long campaignID;

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.bidModifiersSteps().addBidModifierDemographicsToGroup(groupID);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

    }

    @Test
    public void integerArrayInBidModifierToggleItemsTest() {
        api.userSteps.bidModifiersSteps().shouldGetJSONErrorOn(
                ServiceNames.BID_MODIFIERS,
                client,
                Action.TOGGLE,
                new JsonObject()
                        .with(StringUtils.capitalize(ToggleRequestMap.BID_MODIFIER_TOGGLE_ITEMS),
                                Arrays.asList(123, 456, 789)),
                JavaOrPerlApi5Error.java(
                        new Api5Error(8000, Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD2,
                                StringUtils.capitalize(ToggleRequestMap.BID_MODIFIER_TOGGLE_ITEMS)))
                        .perl(
                                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_MUST_CONTAIN_OBJECT,
                                        StringUtils.capitalize(ToggleRequestMap.BID_MODIFIER_TOGGLE_ITEMS))));
    }

    @Test
    public void invalidEnabledFieldTest() {
        String invalidValue = "INVALID_VALUE";
        api.userSteps.bidModifiersSteps().shouldGetJSONErrorOn(
                ServiceNames.BID_MODIFIERS,
                client,
                Action.TOGGLE,
                new JsonObject()
                        .with(StringUtils.capitalize(ToggleRequestMap.BID_MODIFIER_TOGGLE_ITEMS),
                                Arrays.asList(new JsonObject()
                                        .with(StringUtils.capitalize(BidModifierToggleMap.AD_GROUP_ID), groupID)
                                        .with(StringUtils.capitalize(BidModifierToggleMap.ENABLED), invalidValue)
                                        .with(StringUtils.capitalize(BidModifierToggleMap.TYPE),
                                                BidModifierToggleTypeEnum.DEMOGRAPHICS_ADJUSTMENT)
                                )),
                JavaOrPerlApi5Error.java(
                        new Api5Error(8000, Api5ErrorDetailsJava.INCORRECT_ENUMERATE_VALUE,
                                "BidModifierToggleItems." + StringUtils.capitalize(BidModifierToggleMap.ENABLED),
                                "YES, NO"))
                        .perl(
                                new Api5Error(8000, Api5ErrorDetails.INCORRECT_ENUMERATE_VALUE,
                                        StringUtils.capitalize(BidModifierToggleMap.ENABLED))));
    }

    @Test
    public void invalidTypeFieldTest() {
        String invalidValue = "INVALID_VALUE";
        api.userSteps.bidModifiersSteps().shouldGetJSONErrorOn(
                ServiceNames.BID_MODIFIERS,
                client,
                Action.TOGGLE,
                new JsonObject()
                        .with(StringUtils.capitalize(ToggleRequestMap.BID_MODIFIER_TOGGLE_ITEMS),
                                Arrays.asList(new JsonObject()
                                        .with(StringUtils.capitalize(BidModifierToggleMap.AD_GROUP_ID), groupID)
                                        .with(StringUtils.capitalize(BidModifierToggleMap.ENABLED), YesNoEnum.NO)
                                        .with(StringUtils.capitalize(BidModifierToggleMap.TYPE), invalidValue)
                                )),
                JavaOrPerlApi5Error.java(
                        new Api5Error(8000, Api5ErrorDetailsJava.INCORRECT_ENUMERATE_VALUE,
                                "BidModifierToggleItems." + StringUtils.capitalize(BidModifierToggleMap.TYPE),
                                "DEMOGRAPHICS_ADJUSTMENT, RETARGETING_ADJUSTMENT, REGIONAL_ADJUSTMENT, " +
                                        "SERP_LAYOUT_ADJUSTMENT, INCOME_GRADE_ADJUSTMENT"))
                        .perl(
                                new Api5Error(8000, Api5ErrorDetails.INCORRECT_ENUMERATE_VALUE,
                                        StringUtils.capitalize(BidModifierToggleMap.TYPE))
                        ));
    }
}
