package ru.yandex.autotests.direct.api.bids.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 18.09.14.
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class BidsCheckReadRightsInternalRolesTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static long keywordId;
    private static Long autotargetingId;

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String bidsServClient = BidsLogins.BIDS_SERV_CLIENT;
    private static String manager = Logins.MANAGER_DEFAULT;

    static Long servCampaignId;

    @Parameterized.Parameter(0)
    public String internalLogin;

    @Parameterized.Parameters(name = "internalLogin = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Logins.MANAGER_DEFAULT},
                {Logins.PLACER},
                {Logins.SUPPORT},
                {Logins.SUPER_LOGIN},
                {Logins.MEDIA},
                {Logins.SUPER_READER}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void createCampaign() {
        servCampaignId = api.as(manager).userSteps.campaignSteps().addDefaultTextCampaign(bidsServClient);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(servCampaignId, bidsServClient);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, bidsServClient);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(bidsServClient, adGroupId);
        autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(bidsServClient, adGroupId);
        api.protocol(ProtocolType.SOAP);
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1209")
    public void callBidsGetForKeyword() {
        //testplan: string № 3
        GetResponse getResponse = api.as(internalLogin).userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withKeywordIds(keywordId)
                        )
                        .withFieldNames(BidFieldEnum.KEYWORD_ID),
                bidsServClient
        );
        assertThat("Вернулось корректное значение GetResponse.",
                getResponse.getBids().size(), greaterThan(0));
    }

    @Test
    @TestCaseId("2704")
    public void callBidsGetForAutotargeting() {
        GetResponse getResponse = api.as(internalLogin).userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withKeywordIds(autotargetingId)
                        )
                        .withFieldNames(BidFieldEnum.KEYWORD_ID),
                bidsServClient
        );
        assertThat("Получили один автотаргетинг",
                getResponse.getBids().size(), equalTo(1));
    }
}
