package ru.yandex.autotests.direct.api.bids.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 07.11.14.
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@RunWith(Parameterized.class)
public class BidsCheckReadRightsShardingTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String agency = BidsLogins.BIDS_AGENCY_SHARD2;
    private static String subclientIn1Shard =  BidsLogins.BIDS_SUBCLIENT_SHARD1;
    private static String subclientIn2Shard =  BidsLogins.BIDS_SUBCLIENT_SHARD2;

    @Parameterized.Parameter(0)
    public String subclient;

    private long keywordId;

    @Parameterized.Parameters(name = "subclient = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {subclientIn1Shard},
                {subclientIn2Shard},

        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void reshardUsers() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(agency,ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclientIn1Shard, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclientIn2Shard, ShardNumbers.EXTRA_SHARD);
    }


    @Before
    @Step("Подготовка данных для теста")
    public void readBanner(){
        Long campaignID = api.as(agency).userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, subclient);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(subclient, adGroupId);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, subclient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1210")
    public void checkRightsToRead() {
        //DIRECT-35621
        GetResponse getResponse = api.as(agency).userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordId)
                        )
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.KEYWORD_ID),
                subclient);
        assertThat("вернулось правильное количество Bids", getResponse.getBids().size(), equalTo(1));
    }

}
