package ru.yandex.autotests.direct.api.bids.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 18.09.14.
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@RunWith(Parameterized.class)
public class BidsGetByRolesWithAccessTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameter(1)
    public String loginForHeader;

    @Parameterized.Parameter(2)
    public String loginForCreateCampaign;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}, loginForHeader = {1}, loginForCreateCampaign = {2}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {BidsLogins.BIDS_AGENCY, BidsLogins.BIDS_SUBCLIENT, BidsLogins.BIDS_AGENCY},
                {BidsLogins.BIDS_REP_ADMIN_AGENCY, BidsLogins.BIDS_SUBCLIENT, BidsLogins.BIDS_AGENCY},
                {BidsLogins.BIDS_CLIENT, BidsLogins.BIDS_CLIENT, BidsLogins.BIDS_CLIENT},
                {BidsLogins.BIDS_REP_CLIENT, BidsLogins.BIDS_CLIENT, BidsLogins.BIDS_CLIENT}
        };
        return Arrays.asList(data);
    }

    private Long adGroupId;

    @BeforeClass
    public static void reshardUsers() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(BidsLogins.BIDS_SUBCLIENT, ShardNumbers.EXTRA_SHARD);
    }

    @Before
    public void setApiUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(loginForAuthorization);
        Long campaignId = api.as(loginForCreateCampaign).userSteps.campaignSteps().addDefaultTextCampaign(loginForHeader);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, loginForHeader);
        api.protocol(ProtocolType.SOAP);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1214")
    public void callBidsGet() {
        //testplan: string № 4
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(loginForHeader, adGroupId);
        GetResponse getResponse = api.as(loginForAuthorization).userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap()
                                        .withKeywordIds(keywordId)
                        )
                        .withFieldNames(BidFieldEnum.KEYWORD_ID),
                loginForHeader
        );
        assertThat("Размер массива Bids > 0",
                getResponse.getBids().size(), greaterThan(0));
    }

    @Test
    @TestCaseId("2707")
    public void callBidsGetForAutotargeting() {
        Long autotargetingId = api.userSteps.keywordsSteps().addDefaultKeyword(loginForHeader, adGroupId);
        GetResponse getResponse = api.as(loginForAuthorization).userSteps.bidsSteps().bidsGet(
                new GetRequestMap().withSelectionCriteria(
                        new BidsSelectionCriteriaMap().withKeywordIds(autotargetingId)
                ).withFieldNames(BidFieldEnum.KEYWORD_ID),
                loginForHeader
        );
        assertThat("Получили один автотаргетинг",
                getResponse.getBids().size(), equalTo(1));
    }
}
