package ru.yandex.autotests.direct.api.bids.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 18.09.14.
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@RunWith(Parameterized.class)
public class BidsGetByRolesWithoutAccessTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long campaignId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameter(1)
    public String loginForHeader;

    @Parameterized.Parameter(2)
    public String loginForCreateCampaign;

    @Parameterized.Parameter(3)
    public Api5Error error;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}, loginForHeader = {1}, loginForCreateCampaign = {2}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {BidsLogins.BIDS_REP_AGENCY,BidsLogins.BIDS_SUBCLIENT,BidsLogins.BIDS_AGENCY,
                        // TODO DIRECT-72930 Api5ErrorDetails.NO_RIGHTS_TO_THIS_CLIENT
                        new Api5Error(54, Api5ErrorDetails.EMPTY_STRING)},
                {BidsLogins.BIDS_AGENCY,BidsLogins.BIDS_SERV_CLIENT,BidsLogins.MANAGER_DEFAULT,
                        new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)},
                {BidsLogins.BIDS_CLIENT, BidsLogins.BIDS_SUBCLIENT, BidsLogins.BIDS_AGENCY,
                        new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void reshardUsers() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(BidsLogins.BIDS_SUBCLIENT, ShardNumbers.EXTRA_SHARD);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1215")
    public void callBidsGet() {
        //testplan: string № 4
        // DIRECT-35148
        campaignId = api.as(loginForCreateCampaign).userSteps.campaignSteps().addDefaultTextCampaign(loginForHeader);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, loginForHeader);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(loginForHeader, adGroupId);
        api.protocol(ProtocolType.SOAP).as(loginForAuthorization).userSteps.bidsSteps().shouldGetErrorOnBidsGet(new GetRequestMap()
                .withSelectionCriteria(
                        new BidsSelectionCriteriaMap()
                                .withKeywordIds(keywordId)
                )
                .withFieldNames(BidFieldEnum.KEYWORD_ID),
                loginForHeader,
                error
        );

    }
}
