package ru.yandex.autotests.direct.api.bids.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.BidGetItem;
import com.yandex.direct.api.v5.general.PositionEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 27.07.15.
 * https://st.yandex-team.ru/TESTIRT-6479
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@RunWith(Parameterized.class)
@Description("Проверяем содержится ли в CompetitorsBids Prices из SearchPrices.")
@Issue("https://st.yandex-team.ru/DIRECT-44197")
public class BidsGetCompetitorsBidsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(BidsLogins.BIDS_CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static long keywordID;

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(0)
    public PositionEnum position;

    @Parameterized.Parameters(name = "Position = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {PositionEnum.PREMIUMFIRST},
                {PositionEnum.PREMIUMBLOCK},
                {PositionEnum.FOOTERFIRST},
                {PositionEnum.FOOTERBLOCK}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createKeyword() {
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(BidsLogins.BIDS_CLIENT);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
        keywordID = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1216")
    public void callBidsGet(){
        BidGetItem bidGetItem = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordID)
                        )
                        .withFieldNames(BidFieldEnum.COMPETITORS_BIDS, BidFieldEnum.SEARCH_PRICES),
                BidsLogins.BIDS_CLIENT
        ).getBids().get(0);

        assumeThat("в ответе присутствует CompetitorsBids", bidGetItem.getCompetitorsBids(), notNullValue());
        assumeThat("в ответе присутствует SearchPrices", bidGetItem.getSearchPrices(), notNullValue());

        Long priceFromSearchPrices = bidGetItem.getSearchPrices().stream()
                .filter(searchPrice -> searchPrice.getPosition().equals(position))
                .findAny().orElseThrow(() -> new AssertionError("в SearchPrices нет требуемой Price")).getPrice();

        assertThat("Price из SearchPrices содержится ли в CompetitorsBids",
                bidGetItem.getCompetitorsBids().contains(priceFromSearchPrices), equalTo(true));
    }

}
