package ru.yandex.autotests.direct.api.bids.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.BidGetItem;
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsKeywords;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * Created by hmepas on 21.12.16
 */

@Aqua.Test
@Features(BidsFeatures.GET)
@Description("Проверяем правильную работу получения ContextCoverage для кампаний разных стратегий")
@Issue("https://st.yandex-team.ru/DIRECT-61741")
@RunWith(Parameterized.class)
public class BidsGetContextCoverageAvailabilityByStrategy {
    private static final String LOGIN = BidsLogins.BIDS_CLIENT;

    // Должна быть одна фраза на весь тест, и по ней должны быть данные в показометре
    private static final String KEYWORD = BidsKeywords.WITH_POKAZOMETER_DATA;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter
    public String searchStrategyName;

    @Parameterized.Parameter(value = 1)
    public TextCampaignSearchStrategyAddMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public String contextStrategyName;

    @Parameterized.Parameter(value = 3)
    public TextCampaignNetworkStrategyAddMap contextStrategy;

    @Parameterized.Parameter(value = 4)
    public boolean contextCoverageIsNull;

    @Parameterized.Parameters(name = "searchStrategyName = {0}, contextStrategyName = {2}, ContextCoverage is null: {4}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION.value(),
                        new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE.value(),
                        new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        false
                },
                {TextCampaignSearchStrategyTypeEnum.SERVING_OFF.value(),
                        new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                        TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE.value(),
                        new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        false
                },
                {TextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS.value(),
                        new TextCampaignSearchStrategyAddMap().defaultWbMaximumClicks(Currency.RUB),
                        TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT.value(),
                        new TextCampaignNetworkStrategyAddMap().defaultNetworkDefault(),
                        true
                },
                {TextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS.value(),
                        new TextCampaignSearchStrategyAddMap().defaultWbMaximumClicks(Currency.RUB),
                        TextCampaignNetworkStrategyTypeEnum.SERVING_OFF.value(),
                        new TextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        true
                },
                {TextCampaignSearchStrategyTypeEnum.SERVING_OFF.value(),
                        new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                        TextCampaignNetworkStrategyTypeEnum.AVERAGE_CPC.value(),
                        new TextCampaignNetworkStrategyAddMap().defaultAverageCpc(Currency.RUB),
                        false
                },
                {TextCampaignSearchStrategyTypeEnum.AVERAGE_CPC.value(),
                        new TextCampaignSearchStrategyAddMap().defaultAverageCpc(Currency.RUB),
                        TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT.value(),
                        new TextCampaignNetworkStrategyAddMap().defaultNetworkDefault(),
                        true
                }
        });
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2646")
    public void checkContextCoverageNullOrNot() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignIdWithContext = api.as(LOGIN).userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                searchStrategy,
                contextStrategy
        );
        long adgroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignIdWithContext);
        api.userSteps.adsSteps().addDefaultTextAd(adgroupId);
        long keywordId = api.userSteps.keywordsSteps().addKeyword(adgroupId, KEYWORD);

        BidGetItem bidsGetItem =
                api.userSteps.bidsSteps().bidsGet(new GetRequestMap().withSelectionCriteria(
                        new BidsSelectionCriteriaMap().withKeywordIds(keywordId))
                                .withFieldNames(BidFieldEnum.CONTEXT_COVERAGE),
                        LOGIN).getBids().get(0);
        assertThat("в ответе присутствует ContextCoverage " + (contextCoverageIsNull ? " null" : " неnull"),
                bidsGetItem.getContextCoverage().isNil(), Matchers.is(contextCoverageIsNull));
    }
}
