package ru.yandex.autotests.direct.api.bids.get;

import java.util.List;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.BidGetItem;
import com.yandex.direct.api.v5.bids.ContextCoverageItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsKeywords;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 01.09.15.
 * https://st.yandex-team.ru/TESTIRT-6933
 */
@Aqua.Test
@Features(BidsFeatures.GET)
@Description("Проверка размера массива ContextCoverage")
@Issue("https://st.yandex-team.ru/DIRECT-45134")
public class BidsGetContextCoverageSizeTest {

    private static final String LOGIN = BidsLogins.BIDS_CLIENT;

    private static final int CONTEXT_COVERAGE_SIZE = 3;

    private static final String KEYWORD = BidsKeywords.WITH_POKAZOMETER_DATA;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private long keywordId;

    @Before
    @Step("Подготовка данных для теста")
    public void createKeyword() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaignWithIndependentStrategies();

        long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        keywordId = api.userSteps.keywordsSteps().addKeyword(adGroupId, KEYWORD);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1219")
    public void checkMinimumProbabilityValue() {
        BidGetItem bidGetItem = api.userSteps.bidsSteps().bidsGet(new GetRequestMap().withSelectionCriteria(
                        new BidsSelectionCriteriaMap().withKeywordIds(keywordId))
                        .withFieldNames(BidFieldEnum.CONTEXT_COVERAGE),
                LOGIN).getBids().get(0);

        List<ContextCoverageItem> contextCoverage = bidGetItem.getContextCoverage().getValue().getItems();

        assertThat("размер массива ContextCoverage больше находится в допустимых пределах",
                contextCoverage, hasSize(equalTo(CONTEXT_COVERAGE_SIZE)));
    }
}
